/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.listeners.holderchangegui;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractHolderManager;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.gui.HolderInventory;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.HolderPreSelectEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.util.inventory.InventoryResync;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class HolderChangeListenerGui
implements Listener {
    protected static final RacesAndClasses plugin = RacesAndClasses.getPlugin();
    protected final AbstractHolderManager manager;

    public HolderChangeListenerGui(AbstractHolderManager manager) {
        this.manager = manager;
        if (manager != null) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void RemoveAnyHolderItemFromPlayer(InventoryCloseEvent invClose) {
        if (!invClose.getViewers().iterator().hasNext()) {
            return;
        }
        if (!(invClose.getView() instanceof HolderInventory)) {
            return;
        }
        String prefix = this.manager.getContainerTypeAsString();
        if (!invClose.getView().getTopInventory().getName().contains(prefix)) {
            return;
        }
        RaCPlayer player = RaCPlayerManager.get().getPlayer(invClose.getView().getPlayer().getUniqueId());
        if (player == null) {
            return;
        }
        for (ItemStack item : player.getPlayer().getInventory()) {
            if (!this.isHolderItem(item)) continue;
            player.getPlayer().getInventory().remove(item);
        }
        InventoryResync.resync(player.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void stopClosingWhenNoHolder(InventoryCloseEvent event) {
        boolean openClassSelectionAfterwards;
        if (!event.getViewers().iterator().hasNext()) {
            return;
        }
        if (!(event.getView() instanceof HolderInventory)) {
            return;
        }
        String prefix = this.manager.getContainerTypeAsString();
        if (!event.getView().getTopInventory().getName().contains(prefix)) {
            return;
        }
        final Player player = (Player)event.getView().getPlayer();
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
        if (player == null) {
            return;
        }
        AbstractTraitHolder holder = this.manager.getHolderOfPlayer(racPlayer);
        boolean forceReopen = false;
        if (this.manager == plugin.getClassManager()) {
            forceReopen = plugin.getConfigManager().getGeneralConfig().isConfig_cancleGUIExitWhenNoClassPresent();
        }
        if (this.manager == plugin.getRaceManager()) {
            forceReopen = plugin.getConfigManager().getGeneralConfig().isConfig_cancleGUIExitWhenNoRacePresent();
        }
        if (holder == this.manager.getDefaultHolder() && forceReopen) {
            this.rescheduleOpening(racPlayer, 1);
            return;
        }
        if (this.manager == plugin.getRaceManager() && (openClassSelectionAfterwards = plugin.getConfigManager().getGeneralConfig().isConfig_openClassSelectionAfterRaceSelectionWhenNoClass())) {
            HolderInventory classSelectInventory;
            boolean hasDefaultClass;
            boolean bl = hasDefaultClass = racPlayer.getclass() == plugin.getClassManager().getDefaultHolder();
            if (hasDefaultClass && (classSelectInventory = new HolderInventory(player, plugin.getClassManager())).getNumberOfHolder() > 0) {
                plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

                    @Override
                    public void run() {
                        player.openInventory((InventoryView)classSelectInventory);
                    }
                }, 4L);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void playerSelectsHolder(InventoryClickEvent event) {
        if (!event.getViewers().iterator().hasNext()) {
            return;
        }
        if (!(event.getView() instanceof HolderInventory)) {
            return;
        }
        HolderInventory holderInv = (HolderInventory)event.getView();
        if (holderInv.getHolderManager() != this.manager) {
            return;
        }
        Player player = (Player)event.getView().getPlayer();
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            event.setCancelled(true);
            return;
        }
        if (!this.isHolderItem(clickedItem)) {
            event.setCancelled(true);
            return;
        }
        if (!(event.getClick() == ClickType.RIGHT || event.getClick() == ClickType.LEFT && plugin.getConfigManager().getGeneralConfig().isConfig_alsoUseLeftClickInGuis())) {
            event.setCancelled(true);
            return;
        }
        AbstractTraitHolder holder = this.manager.getHolderOfPlayer(racPlayer);
        HolderPreSelectEvent selectEvent = null;
        AbstractTraitHolder newHolder = this.getHolder(clickedItem);
        boolean hasNoHolder = holder == this.manager.getDefaultHolder();
        selectEvent = hasNoHolder ? this.generateHolderSelectEvent(racPlayer, newHolder) : this.generateHolderChangeEvent(racPlayer, newHolder, holder);
        plugin.getServer().getPluginManager().callEvent((Event)selectEvent);
        if (selectEvent.isCancelled() && player != null) {
            player.sendMessage(ChatColor.RED + selectEvent.getCancelMessage());
            return;
        }
        boolean worked = true;
        worked = hasNoHolder ? this.manager.addPlayerToHolder(racPlayer, newHolder.getDisplayName(), true) : this.manager.changePlayerHolder(racPlayer, newHolder.getDisplayName(), true);
        if (worked) {
            if (player != null) {
                player.sendMessage(ChatColor.GREEN + "You are now a " + ChatColor.LIGHT_PURPLE + newHolder.getDisplayName() + ChatColor.GREEN + ".");
                InventoryResync.closeAndResync(player);
            }
        } else if (player != null) {
            player.sendMessage(ChatColor.RED + "Did not work. :( .");
            InventoryResync.closeAndResync(player);
        }
    }

    @EventHandler
    public void playerDropItem(PlayerDropItemEvent event) {
        Item item = event.getItemDrop();
        ItemStack itemStack = item.getItemStack();
        if (this.isHolderItem(itemStack)) {
            item.remove();
        }
    }

    protected abstract HolderPreSelectEvent generateHolderSelectEvent(RaCPlayer var1, AbstractTraitHolder var2);

    protected abstract HolderPreSelectEvent generateHolderChangeEvent(RaCPlayer var1, AbstractTraitHolder var2, AbstractTraitHolder var3);

    private void rescheduleOpening(final RaCPlayer player, int ticks) {
        plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                HolderInventory holderInv;
                if (player != null && player.isOnline() && (holderInv = new HolderInventory(player.getPlayer(), HolderChangeListenerGui.this.manager)).getNumberOfHolder() > 0) {
                    player.getPlayer().openInventory((InventoryView)holderInv);
                    return;
                }
            }
        }, (long)ticks);
    }

    private boolean isHolderItem(ItemStack item) {
        return this.getHolder(item) != null;
    }

    private AbstractTraitHolder getHolder(ItemStack item) {
        if (item == null) {
            return null;
        }
        if (!item.hasItemMeta()) {
            return null;
        }
        if (!item.getItemMeta().hasDisplayName()) {
            return null;
        }
        String itemName = item.getItemMeta().getDisplayName().toLowerCase();
        for (String holderName : this.manager.listAllVisibleHolders()) {
            AbstractTraitHolder holder = this.manager.getHolderByName(holderName);
            String holderTag = holder.getTag().toLowerCase();
            if ("".equals(holderTag)) {
                holderTag = holder.getDisplayName().toLowerCase();
            }
            if (!itemName.contains(holderTag)) continue;
            return holder;
        }
        return null;
    }
}

