/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.listeners.generallisteners;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.entitystatusmanager.stun.StunManager;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class StunCancelListener
implements Listener {
    private final Map<String, Integer> cooldownMap = new HashMap<String, Integer>();
    private final RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public StunCancelListener() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        new DebugBukkitRunnable("StunReduceTask"){

            @Override
            protected void runIntern() {
                Iterator entryIt = StunCancelListener.this.cooldownMap.entrySet().iterator();
                while (entryIt.hasNext()) {
                    Map.Entry entry = entryIt.next();
                    entry.setValue((Integer)entry.getValue() - 1);
                    if ((Integer)entry.getValue() >= 0) continue;
                    entryIt.remove();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 20L);
    }

    private StunManager getStunManager() {
        return this.plugin.getStunManager();
    }

    private boolean isStunned(Entity entity) {
        return this.getStunManager().isStunned(entity);
    }

    private int getRemainingStunSeconds(Entity entity) {
        int restTimeInTicks = this.getStunManager().getRestStunTime(entity);
        int restTimeInSeconds = restTimeInTicks / 20;
        return restTimeInSeconds;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onMovement(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (this.isStunned((Entity)player)) {
            event.setCancelled(true);
            if (this.cooldownMap.containsKey(player.getName())) {
                return;
            }
            String time = String.valueOf(this.getRemainingStunSeconds((Entity)player));
            String action = "move";
            LanguageAPI.sendTranslatedMessage((CommandSender)player, "stun_still", "time", time, "action", action);
            this.cooldownMap.put(player.getName(), 2);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        if (this.isStunned((Entity)player)) {
            event.setCancelled(true);
            if (this.cooldownMap.containsKey(player.getName())) {
                return;
            }
            String time = String.valueOf(this.getRemainingStunSeconds((Entity)player));
            String action = "teleport";
            LanguageAPI.sendTranslatedMessage((CommandSender)player, "stun_still", "time", time, "action", action);
            this.cooldownMap.put(player.getName(), 2);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDamage(EntityDamageByEntityEvent event) {
        if (this.isStunned(event.getDamager())) {
            event.setCancelled(true);
            if (event.getDamager() instanceof Player) {
                Player player = (Player)event.getDamager();
                if (this.cooldownMap.containsKey(player.getName())) {
                    return;
                }
                if (this.cooldownMap.containsKey(player.getName())) {
                    return;
                }
                String time = String.valueOf(this.getRemainingStunSeconds((Entity)player));
                String action = "attack";
                LanguageAPI.sendTranslatedMessage((CommandSender)player, "stun_still", "time", time, "action", action);
                this.cooldownMap.put(player.getName(), 2);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBowShoot(EntityShootBowEvent event) {
        if (this.isStunned((Entity)event.getEntity())) {
            event.setCancelled(true);
            if (event.getEntity() instanceof Player) {
                Player player = (Player)event.getEntity();
                if (this.cooldownMap.containsKey(player.getName())) {
                    return;
                }
                String time = String.valueOf(this.getRemainingStunSeconds((Entity)player));
                String action = "shoot your bow";
                LanguageAPI.sendTranslatedMessage((CommandSender)player, "stun_still", "time", time, "action", action);
                this.cooldownMap.put(player.getName(), 2);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (this.isStunned((Entity)player)) {
            event.setCancelled(true);
            if (this.cooldownMap.containsKey(player.getName())) {
                return;
            }
            String time = String.valueOf(this.getRemainingStunSeconds((Entity)player));
            String action = "place anything";
            LanguageAPI.sendTranslatedMessage((CommandSender)player, "stun_still", "time", time, "action", action);
            this.cooldownMap.put(player.getName(), 2);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (this.isStunned((Entity)player)) {
            event.setCancelled(true);
            if (this.cooldownMap.containsKey(player.getName())) {
                return;
            }
            String time = String.valueOf(this.getRemainingStunSeconds((Entity)player));
            String action = "break anything";
            LanguageAPI.sendTranslatedMessage((CommandSender)player, "stun_still", "time", time, "action", action);
            this.cooldownMap.put(player.getName(), 2);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCreeperExplode(ExplosionPrimeEvent event) {
        if (this.isStunned(event.getEntity())) {
            event.setCancelled(true);
        }
    }
}

