/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.listeners.generallisteners;

import de.tobiyas.racesandclasses.RacesAndClasses;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

public class PlayerLastDamageListener
implements Listener {
    private final Map<String, Long> lastDamageDate = new HashMap<String, Long>();
    private RacesAndClasses plugin = RacesAndClasses.getPlugin();
    private static PlayerLastDamageListener instance;

    public PlayerLastDamageListener() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        instance = this;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDamage(EntityDamageEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getEntityType() == EntityType.PLAYER) {
            Player player = (Player)event.getEntity();
            String playerName = player.getName();
            long currentTime = System.currentTimeMillis();
            this.lastDamageDate.put(playerName, currentTime);
        }
    }

    public static int getTimePassedSinceLastDamageInSeconds(String playerName) {
        if (!PlayerLastDamageListener.instance.lastDamageDate.containsKey(playerName)) {
            return Integer.MAX_VALUE;
        }
        long lastDamage = PlayerLastDamageListener.instance.lastDamageDate.get(playerName);
        long currentTime = System.currentTimeMillis();
        long passedTime = currentTime - lastDamage;
        return (int)(passedTime / 1000L);
    }
}

