/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.listeners.generallisteners;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.playermanagement.playerdisplay.scoreboard.PlayerRaCScoreboardManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.MagicSpellTrait;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;

public class Listener_WandAndBowEquip
implements Listener {
    private RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public Listener_WandAndBowEquip() {
        this.plugin.registerEvents(this);
    }

    @EventHandler
    public void onPlayerChangeItemInhands(PlayerItemHeldEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.plugin.getConfigManager().getGeneralConfig().isConfig_enable_permanent_scoreboard()) {
            return;
        }
        World world = event.getPlayer().getWorld();
        if (this.plugin.getConfigManager().getGeneralConfig().getConfig_worldsDisabled().contains(world.getName())) {
            return;
        }
        RaCPlayer player = RaCPlayerManager.get().getPlayer(event.getPlayer());
        ItemStack item = player.getPlayer().getInventory().getItem(event.getNewSlot());
        if (item != null) {
            boolean newMatIsWand = player.getSpellManager().isWandItem(item);
            if (newMatIsWand && player.getSpellManager().getSpellAmount() > 0) {
                MagicSpellTrait currentActiveSpell = player.getSpellManager().getCurrentSpell();
                if (currentActiveSpell == null) {
                    return;
                }
                player.getScoreboardManager().updateSelectAndShow(PlayerRaCScoreboardManager.SBCategory.Spells);
                if (this.plugin.getCooldownManager().stillHasCooldown(player.getName(), "message.wand") <= 0) {
                    LanguageAPI.sendTranslatedMessage(player, "wand_select_message", "current_spell", currentActiveSpell.getDisplayName());
                    int time = this.plugin.getConfigManager().getGeneralConfig().getConfig_cooldown_on_wand_message();
                    this.plugin.getCooldownManager().setCooldown(player.getName(), "message.wand", time);
                }
                return;
            }
            Material mat = item.getType();
            if (mat == Material.BOW && player.getArrowManager().hasAnyArrow()) {
                player.getScoreboardManager().updateSelectAndShow(PlayerRaCScoreboardManager.SBCategory.Arrows);
                if (this.plugin.getCooldownManager().stillHasCooldown(player.getName(), "message.bow") <= 0) {
                    String currentArrow = player.getArrowManager().getCurrentArrow().getDisplayName();
                    LanguageAPI.sendTranslatedMessage(player, "bow_selected_message", "current_arrow", currentArrow);
                    int time = this.plugin.getConfigManager().getGeneralConfig().getConfig_cooldown_on_bow_message();
                    this.plugin.getCooldownManager().setCooldown(player.getName(), "message.bow", time);
                }
                return;
            }
        }
        player.getScoreboardManager().updateSelectAndShow(PlayerRaCScoreboardManager.SBCategory.Cooldown, -1L);
    }
}

