/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.listeners.generallisteners;

import de.tobiyas.racesandclasses.APIs.CooldownApi;
import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

public class Listener_RaceTeams
implements Listener {
    private final RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public Listener_RaceTeams() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void playerDamagePlayer(EntityDamageByEntityEvent event) {
        if (!this.plugin.getConfigManager().getGeneralConfig().getConfig_enableRaceTeams()) {
            return;
        }
        Entity damager = event.getDamager();
        Entity damagee = event.getEntity();
        if (damager == null || damagee == null) {
            return;
        }
        if (damager.getType() != EntityType.PLAYER || damagee.getType() != EntityType.PLAYER) {
            return;
        }
        RaCPlayer damagerP = RaCPlayerManager.get().getPlayer((Player)damager);
        RaCPlayer damageeP = RaCPlayerManager.get().getPlayer((Player)damagee);
        if (this.plugin.getConfigManager().getRaceTeamManager().sameTeam(damagerP, damageeP)) {
            event.setCancelled(true);
            CompatibilityModifier.EntityDamage.safeSetDamage(0.0, (EntityDamageEvent)event);
            int cooldown = CooldownApi.getCooldownOfPlayer(damagerP.getName(), "friendly.fire");
            if (cooldown <= 0) {
                CooldownApi.setPlayerCooldown(damagerP.getName(), "friendly.fire", 2);
                LanguageAPI.sendTranslatedMessage(damagerP, "same_race_team", "other", damageeP.getDisplayName());
            }
        }
    }
}

