/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.listeners.generallisteners;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.gui.HolderInventory;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race.RaceContainer;
import de.tobiyas.racesandclasses.eventprocessing.events.leveling.LevelUpEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.leveling.PlayerReceiveEXPEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.playermanagement.playerdisplay.scoreboard.PlayerRaCScoreboardManager;
import de.tobiyas.racesandclasses.saving.PlayerSavingData;
import de.tobiyas.racesandclasses.saving.PlayerSavingManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitWithRestrictions;
import de.tobiyas.racesandclasses.util.bukkit.versioning.CertainVersionChecker;
import de.tobiyas.racesandclasses.util.consts.Consts;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;

public class Listener_Player
implements Listener {
    private RacesAndClasses plugin;
    private final Random random = new Random();

    public Listener_Player() {
        this.plugin = RacesAndClasses.getPlugin();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerLeave(PlayerQuitEvent event) {
        if (this.plugin.getConfigManager().getGeneralConfig().isConfig_channels_enable()) {
            this.plugin.getChannelManager().playerQuit(RaCPlayerManager.get().getPlayer(event.getPlayer()));
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerJoin(PlayerJoinEvent event) {
        HolderInventory raceInv;
        RaceContainer racContainer;
        final RaCPlayer player = RaCPlayerManager.get().getPlayer(event.getPlayer());
        boolean racesActive = this.plugin.getConfigManager().getGeneralConfig().isConfig_enableRaces();
        this.plugin.getPlayerManager().getContainer(player);
        RaceContainer container = player.getRace();
        if ((container == null || container == this.plugin.getRaceManager().getDefaultHolder()) && racesActive) {
            String defaultName = this.plugin.getConfigManager().getGeneralConfig().getConfig_takeRaceWhenNoRace();
            if (defaultName == null || defaultName.isEmpty()) {
                defaultName = Consts.defaultRace;
                LanguageAPI.sendTranslatedMessage(player, "login_no_race_selected");
            }
            this.plugin.getRaceManager().addPlayerToHolder(player, defaultName, true);
        }
        if (this.plugin.getConfigManager().getGeneralConfig().isConfig_channels_enable()) {
            this.plugin.getChannelManager().playerLogin(player);
        }
        if (racesActive && this.plugin.getConfigManager().getGeneralConfig().isConfig_adaptListName() && (racContainer = player.getRace()) != null) {
            racContainer.editTABListEntry(player);
        }
        boolean forceSelectOfRace = this.plugin.getConfigManager().getGeneralConfig().isConfig_openRaceSelectionOnJoinWhenNoRace();
        boolean playerHasNoRace = player.getRace() == null || player.getRace() == this.plugin.getRaceManager().getDefaultHolder();
        int scheduledTimeToOpen = this.plugin.getConfigManager().getGeneralConfig().getConfig_debugTimeAfterLoginOpening();
        if (playerHasNoRace && forceSelectOfRace && racesActive && (raceInv = new HolderInventory(player.getPlayer(), this.plugin.getRaceManager())).getNumberOfHolder() > 0) {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    if (player.isOnline()) {
                        player.getPlayer().openInventory((InventoryView)raceInv);
                    }
                }
            }, (long)(scheduledTimeToOpen * 20));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoinCheck(PlayerLoginEvent event) {
        this.checkPlayer(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoinCheck(PlayerJoinEvent event) {
        this.checkPlayer(event.getPlayer());
    }

    private void checkPlayer(Player player) {
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
        PlayerSavingData data = PlayerSavingManager.get().getPlayerData(player.getUniqueId());
        this.plugin.getRaceManager().getHolderOfPlayer(racPlayer);
        this.plugin.getClassManager().getHolderOfPlayer(racPlayer);
        this.plugin.getPlayerManager().getContainer(racPlayer).init();
        data.setLastLogin(System.currentTimeMillis());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChangeWorld(PlayerChangedWorldEvent event) {
        if (this.plugin.getConfigManager().getGeneralConfig().isConfig_channels_enable()) {
            World oldWorld = event.getFrom();
            this.plugin.getChannelManager().playerChangedWorld(oldWorld, RaCPlayerManager.get().getPlayer(event.getPlayer()));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChatEarly(AsyncPlayerChatEvent event) {
        if (!this.plugin.getConfigManager().getGeneralConfig().isConfig_channels_enable()) {
            return;
        }
        String orgMsg = event.getMessage();
        RaCPlayer player = RaCPlayerManager.get().getPlayer(event.getPlayer());
        if (orgMsg != null && orgMsg.length() > 0 && orgMsg.charAt(0) == '/') {
            return;
        }
        String channel = player.getCurrentChatChannel();
        if (!this.plugin.getChannelManager().isMember(player, channel)) {
            player.sendMessage(ChatColor.RED + "You are writing in a channel, you don't have access to. Please change your channel with " + ChatColor.LIGHT_PURPLE + "/channel change" + ChatColor.YELLOW + " [channelname]");
            event.setCancelled(true);
            return;
        }
        this.plugin.getChannelManager().editToChannel(channel, event);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChatLate(AsyncPlayerChatEvent event) {
        if (!this.plugin.getConfigManager().getGeneralConfig().isConfig_channels_enable()) {
            return;
        }
        String message = event.getMessage();
        if (message != null && message.length() > 0 && message.charAt(0) == '/') {
            return;
        }
        String format = event.getFormat();
        format = format.replace("{msg}", "%2$s");
        event.setFormat(format);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerGotEXPEvent(PlayerReceiveEXPEvent event) {
        if (event.isCancelled() || event.getExp() <= 0) {
            return;
        }
        final RaCPlayer player = event.getRaCPlayer();
        new DebugBukkitRunnable("1TickFutureScoreboardScheduler"){

            @Override
            protected void runIntern() {
                player.getScoreboardManager().updateSelectAndShow(PlayerRaCScoreboardManager.SBCategory.General, 4000L);
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    @EventHandler
    public void playerLevelUpEvent(LevelUpEvent event) {
        int oldLevel = event.getFromLevel();
        int newLevel = event.getToLevel();
        if (newLevel < oldLevel) {
            return;
        }
        Player player = event.getPlayer();
        if (player == null || !player.isOnline()) {
            return;
        }
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
        racPlayer.getHealthManager().rescanPlayer();
        racPlayer.getHealthManager().checkMaxHealth();
        racPlayer.getManaManager().rescanPlayer();
        racPlayer.getSpellManager().rescan();
        if (this.plugin.getConfigManager().getGeneralConfig().isConfig_use_levelup_message()) {
            LanguageAPI.sendTranslatedMessage(racPlayer, "level_up_message", "player", player.getDisplayName(), "level", String.valueOf(newLevel));
            for (Trait trait : racPlayer.getTraits()) {
                TraitWithRestrictions twrTrait;
                if (!(trait instanceof TraitWithRestrictions) || (twrTrait = (TraitWithRestrictions)trait).isInLevelRange(oldLevel) || !twrTrait.isInLevelRange(newLevel)) continue;
                LanguageAPI.sendTranslatedMessage(racPlayer, "level_up_new_skill_message", "player", player.getDisplayName(), "level", String.valueOf(newLevel), "traitname", trait.getDisplayName());
            }
        }
        if (this.plugin.getConfigManager().getGeneralConfig().isConfig_use_fireworks_on_level_up() && CertainVersionChecker.isAbove1_7()) {
            int i = 0;
            while (i < 4) {
                Firework fw = (Firework)player.getWorld().spawnEntity(player.getLocation(), EntityType.FIREWORK);
                fw.setFireworkMeta(this.randomizeFireworkMeta(fw.getFireworkMeta()));
                ++i;
            }
        }
    }

    private FireworkMeta randomizeFireworkMeta(FireworkMeta meta) {
        int rt = this.random.nextInt(5);
        FireworkEffect.Type type = FireworkEffect.Type.BALL;
        if (rt == 0) {
            type = FireworkEffect.Type.BALL;
        }
        if (rt == 1) {
            type = FireworkEffect.Type.BALL_LARGE;
        }
        if (rt == 2) {
            type = FireworkEffect.Type.BURST;
        }
        if (rt == 3) {
            type = FireworkEffect.Type.CREEPER;
        }
        if (rt == 4) {
            type = FireworkEffect.Type.STAR;
        }
        Color color1 = Color.fromBGR((int)this.random.nextInt(255), (int)this.random.nextInt(255), (int)this.random.nextInt(255));
        Color color2 = Color.fromBGR((int)this.random.nextInt(255), (int)this.random.nextInt(255), (int)this.random.nextInt(255));
        FireworkEffect effect = FireworkEffect.builder().flicker(this.random.nextBoolean()).withColor(color1).withFade(color2).with(type).trail(this.random.nextBoolean()).build();
        meta.addEffect(effect);
        meta.setPower(0);
        return meta;
    }
}

