/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.listeners.generallisteners;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class Listener_PermanentScoreboard
implements Listener {
    private final RacesAndClasses plugin;
    private final Map<UUID, ClickData> clickMap = new HashMap<UUID, ClickData>();

    public Listener_PermanentScoreboard() {
        this.plugin = RacesAndClasses.getPlugin();
        this.plugin.registerEvents(this);
    }

    @EventHandler
    public void onPlayerChangeItemInhands(PlayerInteractEvent event) {
        ClickData data;
        if (event.isCancelled()) {
            return;
        }
        if (!this.plugin.getConfigManager().getGeneralConfig().isConfig_enable_permanent_scoreboard()) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getItem() != null && event.getItem().getType() != Material.AIR) {
            return;
        }
        World world = event.getPlayer().getWorld();
        if (this.plugin.getConfigManager().getGeneralConfig().getConfig_worldsDisabled().contains(world.getName())) {
            return;
        }
        RaCPlayer player = RaCPlayerManager.get().getPlayer(event.getPlayer());
        UUID id = player.getUniqueId();
        if (!this.clickMap.containsKey(id)) {
            this.clickMap.put(id, new ClickData());
        }
        if ((data = this.clickMap.get(id)).clicked()) {
            data.clear();
            player.getScoreboardManager().cycleToNext();
            event.setCancelled(true);
        }
    }

    private class ClickData {
        private final Queue<Long> clicks = new LinkedList<Long>();

        private ClickData() {
        }

        public void clear() {
            this.clicks.clear();
        }

        private boolean clicked() {
            long now = System.currentTimeMillis();
            this.clicks.add(now);
            if (this.clicks.size() > 3) {
                this.clicks.poll();
            }
            if (this.clicks.size() != 3) {
                return false;
            }
            long lowestVal = now - 2000L;
            for (Long val : this.clicks) {
                if (val >= lowestVal) continue;
                return false;
            }
            return true;
        }
    }
}

