/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.listeners.externalchatlistener;

import de.tobiyas.racesandclasses.APIs.ClassAPI;
import de.tobiyas.racesandclasses.APIs.RaceAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.classevent.AfterClassChangedEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.raceevent.AfterRaceChangedEvent;
import de.tobiyas.util.RaC.player.PlayerUtils;
import net.milkbowl.vault.chat.Chat;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultChatListener
implements Listener {
    private final RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public VaultChatListener() {
        if (Bukkit.getPluginManager().getPlugin("Vault") == null) {
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.initOnline();
    }

    private void initOnline() {
        for (Player player : PlayerUtils.getOnlinePlayers()) {
            this.initPlayer(player);
        }
    }

    private void initPlayer(Player player) {
        try {
            RegisteredServiceProvider chatProvider = Bukkit.getServer().getServicesManager().getRegistration(Chat.class);
            if (chatProvider != null) {
                String className = ClassAPI.getClassNameOfPlayer(player);
                String raceName = RaceAPI.getRaceNameOfPlayer(player);
                ((Chat)chatProvider.getProvider()).setPlayerInfoString(player, "class", className);
                ((Chat)chatProvider.getProvider()).setPlayerInfoString(player, "race", raceName);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @EventHandler
    public void classChanged(AfterClassChangedEvent event) {
        this.initPlayer(event.getPlayer());
    }

    @EventHandler
    public void classChanged(AfterRaceChangedEvent event) {
        this.initPlayer(event.getPlayer());
    }
}

