/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.listeners.externalchatlistener;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class DefaultChatReplacer
implements Listener {
    private final RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public DefaultChatReplacer() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void asyncChatHigh(AsyncPlayerChatEvent event) {
        if (this.plugin.getConfigManager().getGeneralConfig().isConfig_channels_enable()) {
            return;
        }
        this.replace(event);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void asyncChat(AsyncPlayerChatEvent event) {
        if (this.plugin.getConfigManager().getGeneralConfig().isConfig_channels_enable()) {
            return;
        }
        this.replace(event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void asyncChatLow(AsyncPlayerChatEvent event) {
        if (this.plugin.getConfigManager().getGeneralConfig().isConfig_channels_enable()) {
            return;
        }
        this.replace(event);
    }

    private void replace(AsyncPlayerChatEvent event) {
        String format = event.getFormat();
        if (format == null || format.isEmpty()) {
            return;
        }
        String raceTag = "";
        String classTag = "";
        RaCPlayer player = RaCPlayerManager.get().getPlayer(event.getPlayer());
        AbstractTraitHolder holder = player.getRace();
        if (holder != null && "".equals(raceTag = holder.getTag())) {
            raceTag = "[" + holder.getDisplayName() + "]";
        }
        if ((holder = player.getclass()) != null && "".equals(classTag = holder.getTag())) {
            classTag = "[" + holder.getDisplayName() + "]";
        }
        String raceReplacement = "{race}";
        String classReplacement = "{class}";
        if (format.contains(raceReplacement)) {
            format = format.replace(raceReplacement, raceTag);
        }
        if (format.contains(classReplacement)) {
            format = format.replace(classReplacement, classTag);
        }
        event.setFormat(format);
    }
}

