/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.listeners.equipement;

import de.tobiyas.racesandclasses.APIs.LevelAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.classes.ClassContainer;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race.RaceContainer;
import de.tobiyas.racesandclasses.eventprocessing.events.inventoryitemevents.PlayerEquipsArmorEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.util.RaC.collections.ListCreateUtils;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class Listener_raceClassRestrictionOnItems
implements Listener {
    public static final List<String> CLASS_RESTRICTION_PRE = ListCreateUtils.multi("needs class: ", "ben\u00f6tigt klasse: ");
    public static final List<String> RACE_RESTRICTION_PRE = ListCreateUtils.multi("needs race: ", "ben\u00f6tigt rasse: ");
    public static final List<String> LEVEL_RESTRICTION_PRE = ListCreateUtils.multi("needs level: ", "ben\u00f6tigt level: ");
    private final RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public Listener_raceClassRestrictionOnItems() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler
    public void playerInteract(PlayerInteractEvent event) {
        ItemStack item;
        if (this.plugin.getConfigManager().getGeneralConfig().isConfig_disableArmorChecking()) {
            return;
        }
        RaCPlayer player = RaCPlayerManager.get().getPlayer(event.getPlayer());
        if (!this.playerMayEquip(player, item = event.getItem())) {
            event.setCancelled(true);
            player.sendMessage(ChatColor.RED + "You may not use this item.");
        }
    }

    @EventHandler
    public void playerEquip(PlayerEquipsArmorEvent event) {
        ItemStack item;
        if (this.plugin.getConfigManager().getGeneralConfig().isConfig_disableArmorChecking()) {
            return;
        }
        RaCPlayer player = RaCPlayerManager.get().getPlayer(event.getPlayer());
        if (!this.playerMayEquip(player, item = event.getArmorItem())) {
            event.setCancelled(true);
            player.sendMessage(ChatColor.RED + "You may not equip this item.");
        }
    }

    private boolean playerMayEquip(RaCPlayer player, ItemStack item) {
        if (item == null) {
            return true;
        }
        if (!item.hasItemMeta()) {
            return true;
        }
        ItemMeta meta = item.getItemMeta();
        if (!meta.hasLore()) {
            return true;
        }
        for (String loreString : meta.getLore()) {
            boolean found;
            String needed;
            loreString = loreString.toLowerCase();
            loreString = ChatColor.stripColor((String)loreString);
            for (String recog : CLASS_RESTRICTION_PRE) {
                if (!loreString.startsWith(recog)) continue;
                needed = loreString.split(": ")[1];
                ClassContainer classContainer = player.getclass();
                if (classContainer == null) {
                    return false;
                }
                HashSet<String> classes = new HashSet<String>();
                classes.add(classContainer.getDisplayName());
                for (AbstractTraitHolder parent : classContainer.getParents()) {
                    classes.add(parent.getDisplayName());
                }
                found = false;
                for (String string : classes) {
                    if (!string.equalsIgnoreCase(needed)) continue;
                    found = true;
                }
                if (found) continue;
                return false;
            }
            for (String recog : RACE_RESTRICTION_PRE) {
                if (!loreString.startsWith(recog)) continue;
                needed = loreString.split(": ")[1];
                RaceContainer raceContainer = player.getRace();
                if (raceContainer == null) {
                    return false;
                }
                HashSet<String> races = new HashSet<String>();
                races.add(raceContainer.getDisplayName());
                for (AbstractTraitHolder parent : raceContainer.getParents()) {
                    races.add(parent.getDisplayName());
                }
                found = false;
                for (String string : races) {
                    if (!string.equalsIgnoreCase(needed)) continue;
                    found = true;
                }
                if (found) continue;
                return false;
            }
            for (String recog : LEVEL_RESTRICTION_PRE) {
                if (!loreString.startsWith(recog)) continue;
                needed = loreString.split(": ")[1];
                int neededLevel = 0;
                try {
                    neededLevel = Integer.parseInt(needed);
                }
                catch (NumberFormatException races) {
                    // empty catch block
                }
                int currentLevel = LevelAPI.getCurrentLevel(player.getPlayer());
                if (currentLevel >= neededLevel) continue;
                return false;
            }
        }
        return true;
    }
}

