/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.listeners.equipement;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.eventprocessing.events.inventoryitemevents.PlayerEquipsArmorEvent;
import de.tobiyas.racesandclasses.util.inventory.InventoryResync;
import de.tobiyas.util.RaC.items.ItemUtils;
import de.tobiyas.util.RaC.vollotile.VollotileCodeManager;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;

public class Listener_PlayerEquipItem
implements Listener {
    private final RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public Listener_PlayerEquipItem() {
        this.plugin.registerEvents(this);
        if (VollotileCodeManager.getVollotileCode().getVersion().hasArmorstands()) {
            this.plugin.registerEvents(new Greater1_8_Listener());
        }
    }

    @EventHandler
    public void playerClicksToEquip(PlayerInteractEvent event) {
        if (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK) {
            return;
        }
        if (this.plugin.getConfigManager().getGeneralConfig().isConfig_disableArmorChecking()) {
            return;
        }
        ItemUtils.ArmorSlot armorSlot = ItemUtils.getItemSlotEquiping(event.getItem());
        if (armorSlot == ItemUtils.ArmorSlot.NONE) {
            return;
        }
        this.evaluate((Cancellable)event, armorSlot, event.getPlayer(), event.getItem());
    }

    @EventHandler
    public void dropperEquip(BlockDispenseEvent event) {
        if (this.plugin.getConfigManager().getGeneralConfig().isConfig_disableArmorChecking()) {
            return;
        }
        ItemUtils.ArmorSlot slot = ItemUtils.getItemSlotEquiping(event.getItem());
        if (slot == ItemUtils.ArmorSlot.NONE) {
            return;
        }
        Location loc = event.getBlock().getLocation();
        Player near = null;
        for (Player player : loc.getWorld().getPlayers()) {
            if (!(loc.distanceSquared(player.getLocation()) < 4.0)) continue;
            near = player;
            break;
        }
        if (near == null) {
            return;
        }
        this.evaluate((Cancellable)event, slot, near, event.getItem());
    }

    @EventHandler
    public void playerLetItemInItemslot(InventoryClickEvent event) {
        if (this.plugin.getConfigManager().getGeneralConfig().isConfig_disableArmorChecking()) {
            return;
        }
        boolean isPlayerInventory = event.getInventory() instanceof CraftingInventory;
        if (!isPlayerInventory) {
            return;
        }
        if (((CraftingInventory)event.getInventory()).getType() != InventoryType.CRAFTING) {
            return;
        }
        HumanEntity clicker = event.getWhoClicked();
        if (!(clicker instanceof Player)) {
            return;
        }
        Player player = (Player)clicker;
        boolean isArmorSlot = event.getSlotType() == InventoryType.SlotType.ARMOR;
        boolean isEmptyClickedSlot = event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR;
        boolean isEmptyCrosshair = event.getCursor() == null || event.getCursor().getType() == Material.AIR;
        boolean isShift = event.isShiftClick();
        boolean usedNumber = event.getHotbarButton() != -1;
        ItemUtils.ArmorSlot clickedItemArmorSlot = ItemUtils.getItemSlotEquiping(event.getCurrentItem());
        ItemUtils.ArmorSlot cursorArmorSlot = ItemUtils.getItemSlotEquiping(event.getCursor());
        if (usedNumber && isEmptyCrosshair && isArmorSlot) {
            ItemStack used = player.getInventory().getItem(event.getHotbarButton());
            ItemUtils.ArmorSlot slot = ItemUtils.getItemSlotEquiping(used);
            if (slot == ItemUtils.ArmorSlot.NONE) {
                return;
            }
            this.evaluate((Cancellable)event, slot, player, used);
            return;
        }
        if (!isEmptyClickedSlot && isShift && clickedItemArmorSlot != ItemUtils.ArmorSlot.NONE) {
            this.evaluate((Cancellable)event, clickedItemArmorSlot, player, event.getCurrentItem());
            return;
        }
        if (!isEmptyCrosshair && isArmorSlot && cursorArmorSlot != ItemUtils.ArmorSlot.NONE && isEmptyClickedSlot) {
            this.evaluate((Cancellable)event, cursorArmorSlot, player, event.getCursor());
            return;
        }
        if (!isEmptyCrosshair && isArmorSlot && cursorArmorSlot != ItemUtils.ArmorSlot.NONE && clickedItemArmorSlot != ItemUtils.ArmorSlot.NONE && !isEmptyClickedSlot) {
            this.evaluate((Cancellable)event, player, event.getCursor());
            return;
        }
    }

    @EventHandler
    public void playerDraggedStuff(InventoryDragEvent event) {
        if (this.plugin.getConfigManager().getGeneralConfig().isConfig_disableArmorChecking()) {
            return;
        }
        boolean isPlayerInventory = event.getInventory() instanceof CraftingInventory;
        if (!isPlayerInventory) {
            return;
        }
        if (((CraftingInventory)event.getInventory()).getType() != InventoryType.CRAFTING) {
            return;
        }
        HumanEntity clicker = event.getWhoClicked();
        if (!(clicker instanceof Player)) {
            return;
        }
        Player player = (Player)clicker;
        for (Map.Entry entry : event.getNewItems().entrySet()) {
            int id = (Integer)entry.getKey();
            ItemStack item = (ItemStack)entry.getValue();
            if (item == null || item.getType() == Material.AIR || id < 5 || id > 8) continue;
            ItemUtils.ArmorSlot slot = ItemUtils.getItemSlotEquiping(item);
            this.evaluate((Cancellable)event, slot, player, item);
            return;
        }
    }

    protected void evaluate(Cancellable cancellable, ItemUtils.ArmorSlot slot, Player player, ItemStack item) {
        ItemStack equiped = ItemUtils.getItemInArmorSlotOfPlayer(player, slot);
        if (equiped == null || equiped.getType() == Material.AIR) {
            PlayerEquipsArmorEvent newEvent = new PlayerEquipsArmorEvent(player, item);
            Bukkit.getPluginManager().callEvent((Event)newEvent);
            if (newEvent.isCancelled()) {
                cancellable.setCancelled(true);
                InventoryResync.resync(player);
            }
        }
    }

    protected void evaluate(Cancellable cancellable, Player player, ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        PlayerEquipsArmorEvent newEvent = new PlayerEquipsArmorEvent(player, item);
        Bukkit.getPluginManager().callEvent((Event)newEvent);
        if (newEvent.isCancelled()) {
            cancellable.setCancelled(true);
            InventoryResync.resync(player);
        }
    }

    private class Greater1_8_Listener
    implements Listener {
        private Greater1_8_Listener() {
        }
    }
}

