/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.listeners.equipement;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.eventprocessing.TraitEventManager;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.resolvers.WorldResolver;
import de.tobiyas.racesandclasses.eventprocessing.events.inventoryitemevents.PlayerEquipsArmorEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.util.inventory.InventoryResync;
import de.tobiyas.racesandclasses.util.items.ArmorContainer;
import de.tobiyas.racesandclasses.util.items.ItemUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Listener_PlayerEquipChange
implements Listener {
    private Map<RaCPlayer, ArmorContainer> inventoryCache;
    private final RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public Listener_PlayerEquipChange() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.inventoryCache = new HashMap<RaCPlayer, ArmorContainer>();
    }

    @EventHandler
    public void playerClickedOnGroudToEquipItem(PlayerInteractEvent event) {
        boolean disableArmorCheck = this.plugin.getConfigManager().getGeneralConfig().isConfig_disableArmorChecking();
        if (disableArmorCheck) {
            return;
        }
        ItemUtils.ArmorSlot armorSlot = ItemUtils.getItemSlotEquiping(event.getItem());
        if (armorSlot == ItemUtils.ArmorSlot.NONE) {
            return;
        }
        ItemStack equiped = ItemUtils.getItemInArmorSlotOfPlayer(event.getPlayer(), armorSlot);
        if (equiped == null || equiped.getType() == Material.AIR) {
            PlayerEquipsArmorEvent equipEvent = new PlayerEquipsArmorEvent(event.getPlayer(), event.getItem());
            TraitEventManager.fireEvent((Event)equipEvent);
            if (equipEvent.isCancelled()) {
                event.setCancelled(true);
                InventoryResync.resync(event.getPlayer());
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void saveOldArmors(InventoryClickEvent inventEvent) {
        boolean disableArmorCheck = this.plugin.getConfigManager().getGeneralConfig().isConfig_disableArmorChecking();
        if (disableArmorCheck) {
            return;
        }
        InventoryHolder invHolder = inventEvent.getInventory().getHolder();
        if (invHolder == null || !(invHolder instanceof HumanEntity)) {
            return;
        }
        HumanEntity holder = (HumanEntity)invHolder;
        if (!(holder instanceof Player)) {
            return;
        }
        RaCPlayer player = RaCPlayerManager.get().getPlayer((Player)holder);
        boolean onDisabledWorld = WorldResolver.isOnDisabledWorld(player);
        if (onDisabledWorld) {
            return;
        }
        if (!this.inventoryCache.containsKey(player.getName())) {
            this.inventoryCache.put(player, new ArmorContainer(player.getPlayer().getInventory()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClose(InventoryCloseEvent closeEvent) {
        boolean disableArmorCheck = this.plugin.getConfigManager().getGeneralConfig().isConfig_disableArmorChecking();
        if (disableArmorCheck) {
            return;
        }
        if (closeEvent.getPlayer() == null) {
            return;
        }
        if (closeEvent.getView().getBottomInventory().getType() != InventoryType.PLAYER) {
            return;
        }
        HumanEntity humanEntity = closeEvent.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        RaCPlayer player = RaCPlayerManager.get().getPlayer((Player)humanEntity);
        ArmorContainer oldCache = this.inventoryCache.get(player);
        if (oldCache == null) {
            return;
        }
        boolean onDisabledWorld = WorldResolver.isOnDisabledWorld(player);
        if (onDisabledWorld) {
            return;
        }
        List<ItemStack> changed = oldCache.stillSame(closeEvent.getPlayer().getInventory());
        for (ItemStack change : changed) {
            PlayerEquipsArmorEvent event = new PlayerEquipsArmorEvent(player.getPlayer(), change);
            TraitEventManager.fireEvent((Event)event);
            if (!event.isCancelled()) continue;
            this.removeArmor(player, change);
            InventoryResync.resync(player.getPlayer());
        }
        this.inventoryCache.remove(player);
    }

    private void removeArmor(RaCPlayer racPlayer, ItemStack change) {
        Player player = racPlayer.getPlayer();
        ItemUtils.ArmorSlot slot = ItemUtils.getItemSlotEquiping(change);
        if (!player.getInventory().addItem(new ItemStack[]{change}).isEmpty()) {
            player.getWorld().dropItem(player.getLocation(), change);
        }
        ItemStack air = new ItemStack(Material.AIR);
        switch (slot) {
            case HELMET: {
                player.getInventory().setHelmet(air);
                break;
            }
            case CHESTPLATE: {
                player.getInventory().setChestplate(air);
                break;
            }
            case LEGGINGS: {
                player.getInventory().setLeggings(air);
                break;
            }
            case BOOTS: {
                player.getInventory().setBoots(air);
                break;
            }
        }
    }
}

