/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.listeners.commandcomplete;

import de.tobiyas.racesandclasses.RacesAndClasses;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChatTabCompleteEvent;
import org.bukkit.plugin.Plugin;

public class CommandCompleteListener
implements Listener {
    private final RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public CommandCompleteListener() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler
    public void onAutoComplete(PlayerChatTabCompleteEvent event) {
        this.checkCommandAutocomplete(event);
    }

    private void checkCommandAutocomplete(PlayerChatTabCompleteEvent event) {
        String message = event.getChatMessage();
        if (message.contains(" ")) {
            this.checkForFurtherComplete(event);
        } else {
            this.checkAutoCompleteFirstCommand(event.getTabCompletions(), message);
        }
    }

    private void checkForFurtherComplete(PlayerChatTabCompleteEvent event) {
        String commandToFind = event.getChatMessage().split(" ")[0];
        String foundCommand = null;
        block0: for (Map.Entry possible : this.plugin.getDescription().getCommands().entrySet()) {
            String commandName = (String)possible.getKey();
            if (commandToFind.equalsIgnoreCase(commandName)) {
                foundCommand = commandName;
                break;
            }
            if (!((Map)possible.getValue()).containsKey("aliases")) continue;
            Object aliases = ((Map)possible.getValue()).get("aliases");
            if (aliases instanceof String && commandToFind.equalsIgnoreCase((String)aliases)) {
                foundCommand = commandName;
                break;
            }
            if (!(aliases instanceof List)) continue;
            List aliasList = (List)aliases;
            for (String aliasName : aliasList) {
                if (!commandToFind.equalsIgnoreCase(aliasName)) continue;
                foundCommand = commandName;
                continue block0;
            }
        }
        if (foundCommand != null) {
            this.commandFound(foundCommand, event);
            return;
        }
    }

    private void commandFound(String foundCommand, PlayerChatTabCompleteEvent event) {
    }

    private void checkAutoCompleteFirstCommand(Collection<String> tabCompletions, String message) {
        for (String command : this.plugin.getDescription().getCommands().keySet()) {
            if (!command.startsWith(message)) continue;
            tabCompletions.add(command);
        }
    }
}

