/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.listeners.classchangelistener;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.APIs.RaceAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.configuration.racetoclass.RaceNotFoundException;
import de.tobiyas.racesandclasses.cooldown.CooldownManager;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.HolderSelectionPreconditions;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.classes.ClassContainer;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race.RaceContainer;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.classevent.AfterClassChangedEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.classevent.AfterClassSelectedEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.classevent.PreClassSelectEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class ClassChangeSelectionListener
implements Listener {
    private RacesAndClasses plugin = RacesAndClasses.getPlugin();
    private CooldownManager cooldownManager = this.plugin.getCooldownManager();

    public ClassChangeSelectionListener() {
        this.plugin.registerEvents(this);
    }

    @EventHandler(ignoreCancelled=true)
    public void checkRaceHasPermissionForClass(PreClassSelectEvent event) {
        if (event.getClassToSelect() == this.plugin.getClassManager().getDefaultHolder()) {
            return;
        }
        if (this.plugin.getConfigManager().getGeneralConfig().isConfig_useRaceClassSelectionMatrix()) {
            Player playerSelecting = event.getPlayer();
            RaCPlayer player = RaCPlayerManager.get().getPlayer(playerSelecting);
            String className = event.getClassToSelect().getDisplayName();
            RaceContainer holder = player.getRace();
            String raceName = holder.getDisplayName();
            try {
                List<String> classList = this.plugin.getConfigManager().getRaceToClassConfig().getClassesValidForRace(raceName);
                if (classList != null && !classList.contains(className)) {
                    event.setCancelled("Your race can not select the class: " + className);
                }
            }
            catch (RaceNotFoundException raceNotFoundException) {
                // empty catch block
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void checkPlayerhasPermissionToClass(PreClassSelectEvent event) {
        if (event.getClassToSelect() == this.plugin.getClassManager().getDefaultHolder()) {
            return;
        }
        if (!event.isCheckPermissions()) {
            return;
        }
        if (this.plugin.getConfigManager().getGeneralConfig().isConfig_usePermissionsForClasses()) {
            Player player = event.getPlayer();
            String className = event.getClassToSelect().getDisplayName();
            String permissionNode = "RaC.classes." + className;
            if (!this.plugin.getPermissionManager().checkPermissionsSilent((CommandSender)player, permissionNode)) {
                event.setCancelled("You do not have the Permission to select the Class " + className);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void checkPlayerHasUplinkOnChange(PreClassSelectEvent event) {
        String commandName;
        if (!event.isCheckCooldown()) {
            return;
        }
        if (event.getClassToSelect() == this.plugin.getClassManager().getDefaultHolder()) {
            return;
        }
        String playerName = event.getPlayer().getName();
        int remainingCooldown = this.cooldownManager.stillHasCooldown(playerName, commandName = "classchange");
        if (remainingCooldown > 0) {
            String message = ChatColor.RED + "You still have " + ChatColor.LIGHT_PURPLE + remainingCooldown + ChatColor.RED + " seconds cooldown on that command";
            event.setCancelled(message);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void checkPlayerMeetsPreconditions(PreClassSelectEvent event) {
        HolderSelectionPreconditions.HolderPreconditionResult result;
        Player player = event.getPlayer();
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
        AbstractTraitHolder newHolder = event.getHolderToSelect();
        if (newHolder != null && (result = newHolder.getPreconditions().checkPreconditions(racPlayer)) != HolderSelectionPreconditions.HolderPreconditionResult.RESTRICTIONS_MET) {
            String translated = LanguageAPI.translate(racPlayer, result.name().toLowerCase(), "HOLDER", "Specific Class");
            event.setCancelled(translated);
        }
    }

    @EventHandler
    public void givePlayerUplinkAfterSelect(AfterClassSelectedEvent event) {
        if (!event.isGiveCooldown()) {
            return;
        }
        String playerName = event.getPlayer().getName();
        String commandName = "classchange";
        int time = this.plugin.getConfigManager().getGeneralConfig().getConfig_raceChangeCommandUplink();
        this.cooldownManager.setCooldown(playerName, commandName, time);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void rescanHP(AfterClassSelectedEvent selectEvent) {
        if (selectEvent.getPlayer() == null) {
            return;
        }
        if (selectEvent.getPlayer().getName() == null) {
            return;
        }
        RaCPlayer player = RaCPlayerManager.get().getPlayer(selectEvent.getPlayer());
        this.plugin.getPlayerManager().getContainer(player).getHealthManager().forceHPOut();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void resetHotkeys(AfterClassSelectedEvent selectEvent) {
        if (selectEvent.getPlayer() == null) {
            return;
        }
        if (selectEvent.getPlayer().getName() == null) {
            return;
        }
        RaCPlayer player = RaCPlayerManager.get().getPlayer(selectEvent.getPlayer());
        player.getHotkeyInventory().changeToBuildInv();
        player.getHotkeyInventory().clearAllSlots();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void sendCommandAfterChange(AfterClassChangedEvent event) {
        ClassContainer old = event.getOldClass();
        if (old != null) {
            this.executeCommands(RaCPlayerManager.get().getPlayer(event.getPlayer()), old.getCommandExecuteOnExit(), old);
        }
        this.sendCommandAfterSelect(event);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void sendCommandAfterSelect(AfterClassSelectedEvent selectEvent) {
        if (selectEvent.getPlayer() == null) {
            return;
        }
        if (selectEvent.getPlayer().getName() == null) {
            return;
        }
        List<String> commands = this.plugin.getConfigManager().getGeneralConfig().getConfig_class_commands_after_change();
        if (selectEvent.getHolderToSelect() != null) {
            commands.addAll(selectEvent.getHolderToSelect().getCommandExecuteOnJoin());
        }
        if (commands.isEmpty()) {
            return;
        }
        RaCPlayer player = RaCPlayerManager.get().getPlayer(selectEvent.getPlayer());
        this.executeCommands(player, commands, selectEvent.getClassToSelect());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void resetSkillTreeAfterClassChange(AfterClassChangedEvent event) {
        if (this.plugin.getConfigManager().getGeneralConfig().isConfig_useSkillSystem()) {
            RaCPlayer player = RaCPlayerManager.get().getPlayer(event.getPlayer());
            player.getSkillTreeManager().clearSkills();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void resetSkillTreeAfterClassChange(AfterClassSelectedEvent event) {
        if (this.plugin.getConfigManager().getGeneralConfig().isConfig_useSkillSystem()) {
            RaCPlayer player = RaCPlayerManager.get().getPlayer(event.getPlayer());
            player.getSkillTreeManager().clearSkills();
        }
    }

    private void executeCommands(RaCPlayer player, Collection<String> commands, ClassContainer toUse) {
        if (player == null) {
            return;
        }
        for (String command : commands) {
            if (command == null || command.isEmpty()) continue;
            boolean asConsole = command.contains("%CONSOLE%");
            boolean asOp = command.contains("%OP%");
            command = command.startsWith("/") ? command.substring(1) : command;
            command = command.replace("%CONSOLE%", "");
            command = command.replace("%OP%", "");
            command = command.replace("%CLASS%", this.OrEmpty(toUse.getDisplayName()));
            command = command.replace("%RACE%", this.OrEmpty(RaceAPI.getRaceNameOfPlayer(player.getPlayer())));
            command = command.replace("%PLAYER%", player.getName());
            command = command.replace("%DISPLAY%", player.getDisplayName());
            boolean opBefore = player.getPlayer().isOp();
            if (asOp && !asConsole) {
                player.getPlayer().setOp(true);
            }
            try {
                try {
                    if (asConsole) {
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
                    } else {
                        player.getPlayer().chat("/" + command);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!asOp || asConsole || opBefore) continue;
                    player.getPlayer().setOp(false);
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (asOp && !asConsole && !opBefore) {
                    player.getPlayer().setOp(false);
                }
                throw throwable;
            }
            if (!asOp || asConsole || opBefore) continue;
            player.getPlayer().setOp(false);
        }
    }

    private String OrEmpty(String value) {
        return value == null ? "" : value;
    }
}

