/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.infight;

import de.tobiyas.racesandclasses.APIs.InFightAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.eventprocessing.events.entitydamage.EntityHealEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitRegionChecker;
import de.tobiyas.racesandclasses.vollotile.ParticleContainer;
import de.tobiyas.racesandclasses.vollotile.ParticleEffects;
import de.tobiyas.racesandclasses.vollotile.Vollotile;
import de.tobiyas.util.RaC.formating.Pair;
import de.tobiyas.util.RaC.player.PlayerUtils;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class OutOfFightHealer
extends DebugBukkitRunnable {
    private static BukkitTask instance;
    private final Map<UUID, Long> lastHealed = new HashMap<UUID, Long>();

    public OutOfFightHealer() {
        super("OutOfFightHealer");
    }

    @Override
    protected void runIntern() {
        Pair<Double, Double> toHeal = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().getConfig_magic_outOfFightRegeneration();
        if (toHeal == null) {
            return;
        }
        double healValue = (Double)toHeal.first;
        double interval = (Double)toHeal.second * 1000.0;
        if (healValue <= 0.0) {
            return;
        }
        if (interval <= 1000.0) {
            interval = 1000.0;
        }
        long now = System.currentTimeMillis();
        for (Player player : PlayerUtils.getOnlinePlayers()) {
            long lastHealed;
            RaCPlayer racPlayer;
            if (player.getHealth() >= player.getMaxHealth() - 0.05 || InFightAPI.isInFight(racPlayer = RaCPlayerManager.get().getPlayer(player)) || TraitRegionChecker.isInDisabledLocation(racPlayer.getLocation())) continue;
            UUID id = player.getUniqueId();
            long l = lastHealed = this.lastHealed.containsKey(id) ? this.lastHealed.get(id) : 0L;
            if (!((double)(now - lastHealed) > interval)) continue;
            try {
                EntityHealEvent event = new EntityHealEvent((Entity)player, healValue, EntityRegainHealthEvent.RegainReason.MAGIC_REGEN);
                Bukkit.getPluginManager().callEvent((Event)event);
                double newValue = CompatibilityModifier.EntityRegainHealth.safeGetAmount(event);
                if (!(newValue > 0.0)) continue;
                racPlayer.heal(newValue);
                this.lastHealed.put(id, now);
                Vollotile.get().sendOwnParticleEffectToAll(new ParticleContainer(ParticleEffects.SPELL, 20, 0.0f), player.getEyeLocation());
            }
            catch (Throwable exp) {
                exp.printStackTrace();
            }
        }
    }

    public static void launch() {
        if (instance == null) {
            instance = new OutOfFightHealer().runTaskTimer((Plugin)RacesAndClasses.getPlugin(), 40L, 40L);
        }
    }

    public static void kill() {
        if (instance != null) {
            instance.cancel();
        }
    }
}

