/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.infight;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.infight.OutOfFightHealer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.plugin.Plugin;

public class InFightManager
implements Listener {
    private final Map<UUID, Long> inFight = new HashMap<UUID, Long>();
    private long timeInFight = 10000L;

    public InFightManager() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)RacesAndClasses.getPlugin());
    }

    public void reload() {
        this.timeInFight = 10000L;
        this.inFight.clear();
        OutOfFightHealer.kill();
        OutOfFightHealer.launch();
    }

    public boolean isInFight(UUID id) {
        if (!this.inFight.containsKey(id)) {
            return false;
        }
        long lastFightTime = this.inFight.get(id);
        long now = System.currentTimeMillis();
        return now - lastFightTime < this.timeInFight;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerGotDamage(EntityDamageEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getEntity().getType() == EntityType.PLAYER) {
            this.inFight.put(event.getEntity().getUniqueId(), System.currentTimeMillis());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerDamaged(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getDamager().getType() == EntityType.PLAYER) {
            this.inFight.put(event.getDamager().getUniqueId(), System.currentTimeMillis());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void gotAggro(EntityTargetEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getTarget() == null) {
            return;
        }
        if (event.getTarget().getType() == EntityType.PLAYER) {
            this.inFight.put(event.getTarget().getUniqueId(), System.currentTimeMillis());
        }
    }
}

