/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.hotkeys;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.hotkeys.HotKeyInventory;
import de.tobiyas.racesandclasses.hotkeys.Listener_HotKey;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class HotkeyManager
implements Listener {
    private final Map<RaCPlayer, HotKeyInventory> inventories = new HashMap<RaCPlayer, HotKeyInventory>();

    public HotkeyManager() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)RacesAndClasses.getPlugin());
        new Listener_HotKey();
        new DebugBukkitRunnable("HotKeyManagerRefresh"){

            @Override
            protected void runIntern() {
                for (HotKeyInventory inv : HotkeyManager.this.inventories.values()) {
                    inv.updatePlayerInventory();
                }
            }
        }.runTaskTimer((Plugin)RacesAndClasses.getPlugin(), 20L, 20L);
    }

    public HotKeyInventory getInv(RaCPlayer player) {
        HotKeyInventory inv = this.inventories.get(player);
        if (inv == null) {
            inv = new HotKeyInventory(player);
            this.inventories.put(player, inv);
        }
        return inv;
    }

    public HotKeyInventory getInv(UUID playerId) {
        return this.getInv(RaCPlayerManager.get().getPlayer(playerId));
    }

    public HotKeyInventory getInv(Player player) {
        return this.getInv(RaCPlayerManager.get().getPlayer(player));
    }

    public void shutdown() {
        for (RaCPlayer player : this.inventories.keySet()) {
            HotKeyInventory inv = this.inventories.get(player);
            if (!inv.isInSkillMode()) continue;
            inv.changeToBuildInv();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void playerLogout(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        HotKeyInventory inv = this.getInv(player);
        inv.changeToBuildInv();
    }
}

