/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.hotkeys;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.commands.bind.CommandExecutor_BindTrait;
import de.tobiyas.racesandclasses.configuration.global.GeneralConfig;
import de.tobiyas.racesandclasses.hotkeys.HotKeyInventory;
import de.tobiyas.racesandclasses.hotkeys.Listener_HotKey;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitWithRestrictions;
import de.tobiyas.util.RaC.inventorymenu.BasicSelectionInterface;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class HotKeyView
extends BasicSelectionInterface {
    private final RaCPlayer racPlayer;
    private final Map<Integer, ItemStack> emptyItems = new HashMap<Integer, ItemStack>();
    private Trait selectedTrait = null;
    private final boolean skillModeBefore;
    private Inventory inv;

    public HotKeyView(Player player) {
        this(RaCPlayerManager.get().getPlayer(player));
    }

    public HotKeyView(RaCPlayer player) {
        super(player.getPlayer(), null, "Your skills", "All Skills", (JavaPlugin)RacesAndClasses.getPlugin());
        int i;
        this.skillModeBefore = player.getHotkeyInventory().isInSkillMode();
        player.getHotkeyInventory().changeToBuildInv();
        GeneralConfig config = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig();
        Set<Integer> disabled = config.getConfig_disabledHotkeySlots();
        if (config.isConfig_use_permissions_for_hotkeys()) {
            i = 0;
            while (i < 9) {
                if (!disabled.contains(i) && !RacesAndClasses.getPlugin().getPermissionManager().checkPermissionsSilent((CommandSender)player.getRealPlayer(), "RaC.hotkeyslot." + i)) {
                    disabled.add(i);
                }
                ++i;
            }
        }
        i = 0;
        while (i < 9) {
            ItemStack item = null;
            item = disabled.contains(i) ? this.generateItem(Material.ARROW, ChatColor.RED + "DISABLED", "This slot is disabled!") : this.generateItem(Material.WOOL, ChatColor.GREEN + "EMPTY Slot", "slot:" + i);
            this.emptyItems.put(i, item);
            ++i;
        }
        this.racPlayer = player;
        this.redraw();
    }

    private void redraw() {
        GeneralConfig config = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig();
        Set<Integer> disabled = config.getConfig_disabledHotkeySlots();
        if (config.isConfig_use_permissions_for_hotkeys()) {
            int i = 0;
            while (i < 9) {
                if (!disabled.contains(i) && !RacesAndClasses.getPlugin().getPermissionManager().checkPermissionsSilent((CommandSender)this.player, "RaC.hotkeyslot." + i)) {
                    disabled.add(i);
                }
                ++i;
            }
        }
        this.getTopInventory().clear();
        List<Trait> traits = this.racPlayer.getTraits();
        Iterator<Trait> it = traits.iterator();
        while (it.hasNext()) {
            int playerLevel;
            TraitWithRestrictions traitWithRestrictions;
            Trait trait = it.next();
            if (!trait.isBindable()) {
                it.remove();
                continue;
            }
            if (!(trait instanceof TraitWithRestrictions) || (traitWithRestrictions = (TraitWithRestrictions)trait).isInLevelRange(playerLevel = this.racPlayer.getLevelManager().getCurrentLevel())) continue;
            it.remove();
        }
        Collections.sort(traits, new Comparator<Trait>(){

            @Override
            public int compare(Trait o1, Trait o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        int i = 0;
        while (i < 45) {
            if (i >= traits.size()) break;
            Trait trait = traits.get(i);
            ItemStack item = CommandExecutor_BindTrait.generate(trait);
            this.getTopInventory().setItem(i, item);
            ++i;
        }
        int startSelectionRow = 45;
        for (Map.Entry<Integer, ItemStack> entry : this.emptyItems.entrySet()) {
            int index = entry.getKey();
            ItemStack item = entry.getValue().clone();
            this.getTopInventory().setItem(startSelectionRow + index, item);
        }
        for (Map.Entry<Integer, Object> entry : this.racPlayer.getHotkeyInventory().getBindings().entrySet()) {
            int slot = entry.getKey();
            if (disabled.contains(slot)) continue;
            Trait bound = (Trait)entry.getValue();
            this.getTopInventory().setItem(startSelectionRow + slot, CommandExecutor_BindTrait.generate(bound));
        }
        this.setCursor(this.selectedTrait == null ? null : CommandExecutor_BindTrait.generate(this.selectedTrait));
    }

    @Override
    protected boolean onBackPressed() {
        return true;
    }

    @Override
    protected void onAcceptPressed() {
    }

    @Override
    protected void onSelectionItemPressed(ItemStack item) {
        int i;
        Trait trait = Listener_HotKey.getBoundTrait(item, this.racPlayer);
        if (trait != null) {
            this.setCursor(item.clone());
            this.selectedTrait = trait;
        }
        int index = -1;
        GeneralConfig config = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig();
        Set<Integer> disabled = config.getConfig_disabledHotkeySlots();
        if (config.isConfig_use_permissions_for_hotkeys()) {
            i = 0;
            while (i < 9) {
                if (!disabled.contains(i) && !RacesAndClasses.getPlugin().getPermissionManager().checkPermissionsSilent((CommandSender)this.player, "RaC.hotkeyslot." + i)) {
                    disabled.add(i);
                }
                ++i;
            }
        }
        i = 0;
        while (i < 9) {
            ItemStack toCheck = this.getTopInventory().getItem(45 + i);
            if (toCheck.isSimilar(item) && !disabled.contains(i)) {
                index = i;
            }
            ++i;
        }
        if (index >= 0) {
            this.racPlayer.getHotkeyInventory().clearSlot(index);
            if (this.selectedTrait != null) {
                this.racPlayer.getHotkeyInventory().bindTrait(index, this.selectedTrait);
            }
            this.selectedTrait = null;
            this.setCursor(null);
        }
        this.redraw();
        this.redraw();
    }

    @Override
    @EventHandler
    public void onInterfaceInteract(InventoryClickEvent event) {
        if (event.getView() != this) {
            return;
        }
        if (event.isShiftClick()) {
            event.setCancelled(true);
            this.redraw();
            return;
        }
        super.onInterfaceInteract(event);
    }

    @Override
    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getView() != this) {
            return;
        }
        this.setCursor(null);
        super.onInventoryClose(event);
        if (this.skillModeBefore) {
            HotKeyInventory inv = this.racPlayer.getHotkeyInventory();
            inv.changeToSkillInv();
        }
    }

    @Override
    protected void scheduleOpeningOfParent() {
        this.racPlayer.getHotkeyInventory().forceUpdateOfInv();
        super.scheduleOpeningOfParent();
    }

    @Override
    public Inventory getTopInventory() {
        if (this.inv == null) {
            this.inv = Bukkit.createInventory((InventoryHolder)this.player, (int)54);
        }
        return this.inv;
    }

    @Override
    public Inventory getBottomInventory() {
        return this.player.getInventory();
    }
}

