/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.hotkeys;

import de.tobiyas.racesandclasses.APIs.CooldownApi;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.configuration.global.GeneralConfig;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.saving.PlayerSavingData;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitWithRestrictions;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class HotKeyInventory {
    private static final String BIND_KEY = ChatColor.AQUA + "Trait: ";
    private final Map<Integer, Trait> traitBindings = new HashMap<Integer, Trait>();
    private final Map<Integer, ItemStack> oldHotkeyBar = new HashMap<Integer, ItemStack>();
    private final RaCPlayer player;
    private boolean isInSkillMode = false;

    public HotKeyInventory(RaCPlayer player) {
        this.player = player;
        this.loadFromFile();
    }

    public void loadFromFile() {
        this.traitBindings.clear();
        PlayerSavingData data = this.player.getPlayerSaveData();
        Map<Integer, String> bindings = data.getHotKeys();
        for (Map.Entry<Integer, String> entry : bindings.entrySet()) {
            int key = entry.getKey();
            String name = entry.getValue();
            for (Trait trait : this.player.getTraits()) {
                if (!trait.getDisplayName().equals(name)) continue;
                this.traitBindings.put(key, trait);
            }
        }
    }

    public void bindTrait(int slot, Trait trait) {
        if (trait == null || !trait.isBindable()) {
            return;
        }
        PlayerSavingData data = this.player.getPlayerSaveData();
        data.setHotKey(slot, trait.getDisplayName());
        this.traitBindings.put(slot, trait);
    }

    public void clearSlot(int slot) {
        if (!this.traitBindings.containsKey(slot)) {
            return;
        }
        PlayerSavingData data = this.player.getPlayerSaveData();
        data.clearHotKey(slot);
        this.traitBindings.remove(slot);
    }

    public void clearAllSlots() {
        this.traitBindings.clear();
        PlayerSavingData data = this.player.getPlayerSaveData();
        data.clearHotKeys();
    }

    public void updatePlayerInventory() {
        if (!this.player.isOnline()) {
            return;
        }
        if (!this.isInSkillMode) {
            return;
        }
        if (this.traitBindings.isEmpty()) {
            return;
        }
        Material shortcutMat = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().getConfig_hotkeys_material();
        short maxShortcutDurability = shortcutMat.getMaxDurability();
        for (Map.Entry<Integer, Trait> entry : this.traitBindings.entrySet()) {
            TraitWithRestrictions res;
            int maxCD;
            int slot = entry.getKey();
            Trait trait = entry.getValue();
            ItemStack item = this.player.getPlayer().getInventory().getItem(slot);
            if (item == null || item.getType() != shortcutMat || !(trait instanceof TraitWithRestrictions) || (maxCD = (res = (TraitWithRestrictions)trait).getMaxUplinkTime()) <= 0) continue;
            String cooldownName = ((TraitWithRestrictions)trait).getCooldownName();
            int cd = CooldownApi.getCooldownOfPlayer(this.player.getName(), cooldownName);
            if (cd >= 0) {
                float percent = (float)cd / (float)maxCD;
                float val = (float)maxShortcutDurability * percent;
                if (val <= 0.0f) {
                    val = 1.0f;
                }
                if (val >= (float)maxShortcutDurability) {
                    val = maxShortcutDurability - 1;
                }
                item.setDurability((short)val);
            }
            if (cd >= 0) continue;
            item.setDurability((short)0);
        }
    }

    public void changeToBuildInv() {
        if (!this.isInSkillMode) {
            return;
        }
        Player player = this.player.getPlayer();
        if (player == null) {
            return;
        }
        if (!player.isOnline()) {
            return;
        }
        Set<Integer> disabled = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().getConfig_disabledHotkeySlots();
        int i = 0;
        while (i < 9) {
            if (!disabled.contains(i) && this.traitBindings.containsKey(i)) {
                player.getInventory().setItem(i, null);
            }
            ++i;
        }
        for (Map.Entry<Integer, ItemStack> entry : this.oldHotkeyBar.entrySet()) {
            int slot = entry.getKey();
            ItemStack item = entry.getValue();
            if (disabled.contains(slot)) continue;
            player.getInventory().setItem(slot, item);
        }
        this.oldHotkeyBar.clear();
        this.isInSkillMode = false;
    }

    public void changeToSkillInv() {
        int i;
        if (this.isInSkillMode) {
            return;
        }
        Player player = this.player.getPlayer();
        if (player == null) {
            return;
        }
        GeneralConfig config = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig();
        Set<Integer> disabled = config.getConfig_disabledHotkeySlots();
        if (config.isConfig_use_permissions_for_hotkeys()) {
            i = 0;
            while (i < 9) {
                if (!RacesAndClasses.getPlugin().getPermissionManager().checkPermissionsSilent((CommandSender)player, "RaC.hotkeyslot." + i)) {
                    disabled.add(i);
                }
                ++i;
            }
        }
        this.oldHotkeyBar.clear();
        i = 0;
        while (i < 9) {
            ItemStack toMove;
            if (!disabled.contains(i) && this.traitBindings.containsKey(i) && (toMove = player.getInventory().getItem(i)) != null && toMove.getType() != Material.AIR) {
                int slot = 9;
                while (slot < player.getInventory().getSize()) {
                    ItemStack toMoveTo = player.getInventory().getItem(slot);
                    if (toMoveTo == null || toMoveTo.getType() == Material.AIR) {
                        player.getInventory().setItem(slot, toMove.clone());
                        player.getInventory().setItem(i, null);
                        break;
                    }
                    ++slot;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 9) {
            if (!disabled.contains(i) && this.traitBindings.containsKey(i)) {
                ItemStack item = player.getInventory().getItem(i);
                if (item != null && item.getType() != Material.AIR) {
                    this.oldHotkeyBar.put(i, item.clone());
                }
                ItemStack newItem = HotKeyInventory.generateItem(this.traitBindings.get(i));
                player.getInventory().setItem(i, newItem == null ? HotKeyInventory.getEmptyItem() : newItem);
            }
            ++i;
        }
        this.isInSkillMode = true;
    }

    public void forceUpdateOfInv() {
        if (!this.isInSkillMode) {
            return;
        }
        Player player = this.player.getPlayer();
        if (player == null) {
            return;
        }
        Set<Integer> disabled = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().getConfig_disabledHotkeySlots();
        int i = 0;
        while (i < 9) {
            if (!disabled.contains(i) && this.traitBindings.containsKey(i)) {
                ItemStack item = HotKeyInventory.generateItem(this.traitBindings.get(i));
                player.getInventory().setItem(i, item == null ? HotKeyInventory.getEmptyItem() : item);
            }
            ++i;
        }
    }

    public static ItemStack generateItem(Trait trait) {
        if (trait == null) {
            return null;
        }
        Material shortcutMat = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().getConfig_hotkeys_material();
        ItemStack item = new ItemStack(shortcutMat);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.valueOf(BIND_KEY) + trait.getDisplayName());
        LinkedList<String> lore = new LinkedList<String>();
        lore.add("Switch the item to this slot to cast the Spell,");
        lore.add("or simply right-click with it.");
        lore.add("");
        lore.add(ChatColor.YELLOW + trait.getPrettyConfiguration());
        itemMeta.setLore(lore);
        item.setItemMeta(itemMeta);
        return item;
    }

    public static ItemStack getEmptyItem() {
        ItemStack item = new ItemStack(Material.FLINT);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(String.valueOf(BIND_KEY) + "EMPTY");
        LinkedList<String> lore = new LinkedList<String>();
        lore.add("Put an Skill to this Slot to to fill it.");
        itemMeta.setLore(lore);
        item.setItemMeta(itemMeta);
        return item;
    }

    public boolean isInBuildingMode() {
        return !this.isInSkillMode;
    }

    public boolean isInSkillMode() {
        return this.isInSkillMode;
    }

    public Map<Integer, Trait> getBindings() {
        return new HashMap<Integer, Trait>(this.traitBindings);
    }
}

