/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.eventprocessing.events.entitydamage;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.util.Vector;

public class EntityKnockbackEvent
extends EntityEvent
implements Cancellable {
    private Vector knockbackVector;
    private boolean isCancled;

    public EntityKnockbackEvent(Entity target, Entity source) {
        super(target);
        this.knockbackVector = this.calcVector(target, source);
        this.isCancled = false;
    }

    public EntityKnockbackEvent(Entity what, Vector knockbackVector) {
        super(what);
        this.knockbackVector = knockbackVector;
        this.isCancled = false;
    }

    public boolean isCancelled() {
        return this.isCancled;
    }

    public void setCancelled(boolean cancled) {
        this.isCancled = cancled;
    }

    public HandlerList getHandlers() {
        return null;
    }

    private Vector calcVector(Entity target, Entity source) {
        Location locTarget = target.getLocation();
        Location locDamager = source.getLocation();
        Location result = locTarget.subtract(locDamager);
        Vector knockBack = result.toVector();
        knockBack.normalize();
        return knockBack;
    }

    public void multiplyKnockBack(double multi) {
        this.knockbackVector.multiply(multi);
    }

    public void addKnockBack(Vector vector) {
        this.knockbackVector.add(vector);
    }

    public Vector getKnockback() {
        return this.knockbackVector;
    }

    public void setKnockback(Vector vector) {
        this.knockbackVector = vector;
    }

    public void setKnockback(Entity target, Entity source) {
        this.knockbackVector = this.calcVector(target, source);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EntityKnockbackEvent)) {
            return false;
        }
        EntityKnockbackEvent realEvent = (EntityKnockbackEvent)((Object)obj);
        if (this.knockbackVector != realEvent.getKnockback()) {
            return false;
        }
        if (this.entity != realEvent.getEntity()) {
            return false;
        }
        return this.isCancled == realEvent.isCancelled();
    }
}

