/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.eventprocessing.eventresolvage.resolvers;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.world.WorldEvent;

public class WorldResolver {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getWorldNameOfEvent(Event event) {
        try {
            if (event instanceof PlayerEvent) {
                PlayerEvent playerEvent = (PlayerEvent)event;
                if (playerEvent.getPlayer() != null) return playerEvent.getPlayer().getLocation().getWorld().getName();
                return "noWorldFoundForEvent";
            }
            if (event instanceof BlockEvent) {
                BlockEvent blockEvent = (BlockEvent)event;
                return blockEvent.getBlock().getWorld().getName();
            }
            if (event instanceof InventoryEvent) {
                InventoryEvent inventoryEvent = (InventoryEvent)event;
                if (!inventoryEvent.getViewers().isEmpty()) return ((HumanEntity)inventoryEvent.getViewers().get(0)).getWorld().getName();
                return "noWorldFoundForEvent";
            }
            if (event instanceof WorldEvent) {
                WorldEvent worldEvent = (WorldEvent)event;
                return worldEvent.getWorld().getName();
            }
            if (!(event instanceof EntityEvent)) return "noWorldFoundForEvent";
            EntityEvent entityEvent = (EntityEvent)event;
            Entity entity = entityEvent.getEntity();
            if (entity != null) return entity.getWorld().getName();
            return "noWorldFoundForEvent";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "noWorldFoundForEvent";
    }

    public static boolean isOnDisabledWorld(Player player) {
        if (player == null) {
            return false;
        }
        return WorldResolver.isDisabledWorld(player.getWorld());
    }

    public static boolean isOnDisabledWorld(RaCPlayer player) {
        return WorldResolver.isDisabledWorld(player.getWorld());
    }

    public static boolean isOnDisabledWorld(String playerName) {
        RaCPlayer player = RaCPlayerManager.get().getPlayerByName(playerName);
        return WorldResolver.isOnDisabledWorld(player);
    }

    public static boolean isDisabledWorld(World world) {
        if (world == null) {
            return false;
        }
        String worldName = world.getName();
        for (String disabled : RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().getConfig_worldsDisabled()) {
            if (!disabled.equalsIgnoreCase(worldName)) continue;
            return true;
        }
        return false;
    }
}

