/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.eventprocessing.eventresolvage.resolvers;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.PlayerAction;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;

public class EventActionResolver {
    public static PlayerAction resolveAction(Event event, Player player) {
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
        if (event instanceof PlayerInteractEntityEvent) {
            return PlayerAction.INTERACT_ENTITY;
        }
        if (event instanceof PlayerInteractEvent) {
            ItemStack itemInHands = ((PlayerInteractEvent)event).getItem();
            if (racPlayer.getSpellManager().isWandItem(itemInHands)) {
                if (((PlayerInteractEvent)event).getAction() == Action.RIGHT_CLICK_BLOCK || ((PlayerInteractEvent)event).getAction() == Action.RIGHT_CLICK_AIR) {
                    return PlayerAction.CHANGE_SPELL;
                }
                if (((PlayerInteractEvent)event).getAction() == Action.LEFT_CLICK_BLOCK || ((PlayerInteractEvent)event).getAction() == Action.LEFT_CLICK_AIR) {
                    return PlayerAction.CAST_SPELL;
                }
            }
            if (itemInHands != null && itemInHands.getType() == Material.BOW && (((PlayerInteractEvent)event).getAction() == Action.LEFT_CLICK_BLOCK || ((PlayerInteractEvent)event).getAction() == Action.LEFT_CLICK_AIR)) {
                return PlayerAction.CHANGE_ARROW;
            }
            if (((PlayerInteractEvent)event).getAction() == Action.RIGHT_CLICK_BLOCK) {
                return PlayerAction.INTERACT_BLOCK;
            }
            if (((PlayerInteractEvent)event).getAction() == Action.LEFT_CLICK_BLOCK) {
                return PlayerAction.HIT_BLOCK;
            }
            if (((PlayerInteractEvent)event).getAction() == Action.LEFT_CLICK_AIR) {
                return PlayerAction.HIT_AIR;
            }
            if (((PlayerInteractEvent)event).getAction() == Action.RIGHT_CLICK_AIR) {
                return PlayerAction.INTERACT_AIR;
            }
        }
        if (event instanceof EntityDamageEvent && ((EntityDamageEvent)event).getEntity() == player) {
            return PlayerAction.TAKE_DAMAGE;
        }
        if (event instanceof EntityDamageByEntityEvent) {
            Projectile projectile;
            LivingEntity shooter;
            EntityDamageByEntityEvent damageEvent = (EntityDamageByEntityEvent)event;
            if (damageEvent.getDamager() == player) {
                return PlayerAction.DO_DAMAGE;
            }
            if (damageEvent.getDamager() instanceof Projectile && (shooter = CompatibilityModifier.Shooter.getShooter(projectile = (Projectile)damageEvent.getDamager())) instanceof Player) {
                return PlayerAction.DO_DAMAGE;
            }
        }
        if (event instanceof PlayerMoveEvent) {
            return PlayerAction.PLAYER_MOVED;
        }
        if (event instanceof EntityTargetEvent && ((EntityTargetEvent)event).getTarget() == player) {
            return PlayerAction.PLAYER_TARGETED;
        }
        return PlayerAction.NONE;
    }
}

