/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.eventprocessing.eventresolvage;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.PlayerAction;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.resolvers.EventActionResolver;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.resolvers.EventDamageHealResolver;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.resolvers.EventPlayerResolver;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.resolvers.EventTargetResolver;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class EventWrapperFactory {
    public static EventWrapper buildFromEvent(Event event) {
        Player player = EventPlayerResolver.resolvePlayer(event);
        if (player == null) {
            return null;
        }
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
        World world = player.getWorld();
        PlayerAction action = EventActionResolver.resolveAction(event, player);
        Entity targetEntity = EventTargetResolver.getTargetEntityFromEvent(event);
        if (targetEntity == null) {
            targetEntity = player;
        }
        Block targetBlock = EventTargetResolver.getTargetBlockFromEvent(event);
        boolean arrowInvolved = EventPlayerResolver.isArrowInvolved(event);
        double damageHealValue = EventDamageHealResolver.getDamageHealFromEvent(event);
        EntityDamageEvent.DamageCause damageCause = EventDamageHealResolver.getDamageCauseFromEvent(event);
        EntityRegainHealthEvent.RegainReason regainReason = EventDamageHealResolver.getRegainReasonFromEvent(event);
        EventWrapper.RegainResource regainResource = EventDamageHealResolver.getRegainResource(event);
        return new EventWrapper(racPlayer, world, action, targetEntity, targetBlock, damageHealValue, damageCause, arrowInvolved, regainReason, regainResource, event);
    }

    public static EventWrapper buildOnlyWithplayer(Player player) {
        RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
        if (!racPlayer.isOnline()) {
            return null;
        }
        return EventWrapperFactory.buildOnlyWithplayer(racPlayer);
    }

    public static EventWrapper buildOnlyWithplayer(RaCPlayer player) {
        return new EventWrapper(player, player.getWorld(), PlayerAction.NONE, null, null, -1.0, null, false, null, null, null);
    }
}

