/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.eventprocessing;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.APIs.MessageScheduleApi;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.arrow.ArrowManager;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.TraitHolderCombinder;
import de.tobiyas.racesandclasses.eventprocessing.DoubleEventRemover;
import de.tobiyas.racesandclasses.eventprocessing.Simple_event_executor;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapperFactory;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.PlayerAction;
import de.tobiyas.racesandclasses.eventprocessing.events.traittrigger.PostTraitTriggerEvent;
import de.tobiyas.racesandclasses.listeners.interneventproxy.Listener_Proxy;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.playerdisplay.scoreboard.PlayerRaCScoreboardManager;
import de.tobiyas.racesandclasses.traitcontainer.TraitStore;
import de.tobiyas.racesandclasses.traitcontainer.container.TraitsList;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.bypasses.ByPassWorldDisabledCheck;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.bypasses.BypassHolderCheck;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.bypasses.StaticTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.MagicSpellTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitRestriction;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitWithCost;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitWithRestrictions;
import de.tobiyas.racesandclasses.traitcontainer.traits.arrows.AbstractArrow;
import de.tobiyas.racesandclasses.util.friend.EnemyChecker;
import de.tobiyas.racesandclasses.util.traitutil.TraitBypassCheck;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;

public class TraitEventManager {
    private RacesAndClasses plugin;
    private static long timings = 0L;
    private static long calls = 0L;
    private static TraitEventManager manager;
    private HashMap<Class<?>, Set<Trait>> traitList;
    private HashMap<Integer, Long> eventIDs;
    private int errorsPerMin = 0;
    private boolean spamPreventionActive = false;
    private List<String> registeredEventsAsName = new LinkedList<String>();

    public TraitEventManager() {
        this.plugin = RacesAndClasses.getPlugin();
        TraitsList.initStaticTraits();
        TraitsList.initInternalTraits();
        TraitStore.importFromFileSystem();
        manager = this;
        this.traitList = new HashMap();
        this.eventIDs = new HashMap();
        new DoubleEventRemover(this);
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                TraitEventManager.this.errorsPerMin = 0;
            }
        }, 1200L, 1200L);
    }

    public void init() {
        this.createStaticTraits();
    }

    private void createStaticTraits() {
        TraitStore.buildTraitWithoutHolderByName("DeathCheckerTrait").generalInit();
        TraitStore.buildTraitWithoutHolderByName("STDAxeDamageTrait").generalInit();
        TraitStore.buildTraitWithoutHolderByName("ArmorTrait").generalInit();
    }

    private boolean fireEventIntern(Event event) {
        if (event instanceof EnemyChecker.FriendDetectEvent) {
            return false;
        }
        ++calls;
        boolean changedSomething = false;
        if (this.eventIDs.containsKey(event.hashCode())) {
            return false;
        }
        this.eventIDs.put(event.hashCode(), System.currentTimeMillis());
        EventWrapper eventWrapper = EventWrapperFactory.buildFromEvent(event);
        if (eventWrapper == null) {
            return false;
        }
        boolean disabledOnWorld = this.checkDisabledPerWorld(eventWrapper.getWorld());
        HashSet traitsToCheck = new HashSet();
        for (Class<?> clazz : this.traitList.keySet()) {
            if (!clazz.isAssignableFrom(event.getClass())) continue;
            traitsToCheck.addAll(this.traitList.get(clazz));
        }
        for (Trait trait : traitsToCheck) {
            RaCPlayer player;
            long timeBefore;
            block35: {
                boolean hasBypassForEvent;
                block34: {
                    block33: {
                        TraitRestriction restriction;
                        block32: {
                            ArrowManager arrowManager;
                            block31: {
                                AbstractArrow newArrow;
                                block30: {
                                    block28: {
                                        block29: {
                                            block27: {
                                                timeBefore = System.currentTimeMillis();
                                                if (trait == null) continue;
                                                if (!disabledOnWorld || trait.getClass().isAnnotationPresent(ByPassWorldDisabledCheck.class)) break block27;
                                                this.plugin.getStatistics().eventTime(trait.getName(), System.currentTimeMillis() - timeBefore);
                                                continue;
                                            }
                                            player = eventWrapper.getPlayer();
                                            if (trait instanceof StaticTrait) break block28;
                                            if (player != null) break block29;
                                            this.plugin.getStatistics().eventTime(trait.getName(), System.currentTimeMillis() - timeBefore);
                                            continue;
                                        }
                                        if (trait.getClass().isAnnotationPresent(BypassHolderCheck.class) || TraitHolderCombinder.getReducedTraitsOfPlayer(player).contains(trait)) break block28;
                                        this.plugin.getStatistics().eventTime(trait.getName(), System.currentTimeMillis() - timeBefore);
                                        continue;
                                    }
                                    hasBypassForEvent = TraitBypassCheck.hasBypass(trait.getClass(), event.getClass());
                                    if (!(trait instanceof MagicSpellTrait) || !(event instanceof PlayerInteractEvent) || hasBypassForEvent) break block30;
                                    TraitWithCost magicTrait = (TraitWithCost)((Object)trait);
                                    if (player.getSpellManager().getCurrentSpell() == magicTrait) break block30;
                                    this.plugin.getStatistics().eventTime(trait.getName(), System.currentTimeMillis() - timeBefore);
                                    continue;
                                }
                                if (!(trait instanceof AbstractArrow) || eventWrapper.getPlayerAction() != PlayerAction.CHANGE_ARROW || !player.getArrowManager().hasAnyArrow() || player.getArrowManager().getCurrentArrow() != trait || hasBypassForEvent) break block31;
                                boolean foreward = !player.getPlayer().isSneaking();
                                AbstractArrow abstractArrow = newArrow = foreward ? player.getArrowManager().nextArrow() : player.getArrowManager().previousArrow();
                                if (newArrow != null && newArrow != trait) {
                                    if (!this.plugin.getConfigManager().getGeneralConfig().isConfig_enable_permanent_scoreboard()) {
                                        player.getScoreboardManager().updateSelectAndShow(PlayerRaCScoreboardManager.SBCategory.Arrows);
                                    }
                                    LanguageAPI.sendTranslatedMessage((CommandSender)player.getPlayer(), "arrow_change", "trait_name", newArrow.getDisplayName());
                                }
                                this.plugin.getStatistics().eventTime(trait.getName(), System.currentTimeMillis() - timeBefore);
                                continue;
                            }
                            if (!(trait instanceof AbstractArrow) || hasBypassForEvent || (arrowManager = player.getArrowManager()).hasAnyArrow() && arrowManager.getCurrentArrow() == trait) break block32;
                            this.plugin.getStatistics().eventTime(trait.getName(), System.currentTimeMillis() - timeBefore);
                            continue;
                        }
                        if (player == null || !(trait instanceof TraitWithRestrictions) || hasBypassForEvent || (restriction = ((TraitWithRestrictions)trait).checkRestrictions(eventWrapper)) == TraitRestriction.None) break block33;
                        this.plugin.getStatistics().eventTime(trait.getName(), System.currentTimeMillis() - timeBefore);
                        continue;
                    }
                    if (hasBypassForEvent || trait.canBeTriggered(eventWrapper)) break block34;
                    this.plugin.getStatistics().eventTime(trait.getName(), System.currentTimeMillis() - timeBefore);
                    continue;
                }
                if (!(trait instanceof TraitWithCost) || hasBypassForEvent) break block35;
                TraitWithCost costTrait = (TraitWithCost)((Object)trait);
                if (player.getSpellManager().canCastSpell(costTrait)) break block35;
                costTrait.triggerButDoesNotHaveEnoghCostType(eventWrapper);
                this.plugin.getStatistics().eventTime(trait.getName(), System.currentTimeMillis() - timeBefore);
                continue;
            }
            try {
                this.plugin.getStatistics().traitTriggered(trait);
                TraitResults result = trait.trigger(eventWrapper);
                if (result.isTriggered()) {
                    changedSomething = true;
                    RacesAndClasses.getPlugin().fireEventToBukkit((Event)new PostTraitTriggerEvent(eventWrapper, trait));
                    if (trait instanceof TraitWithRestrictions && player != null && result.isSetCooldownOnPositiveTrigger()) {
                        TraitWithRestrictions restrictionTrait = (TraitWithRestrictions)trait;
                        String playerName = player.getName();
                        String cooldownName = restrictionTrait.getCooldownName();
                        int uplinkTraitTime = restrictionTrait.getMaxUplinkTime();
                        if (uplinkTraitTime > 0) {
                            this.plugin.getCooldownManager().setCooldown(playerName, cooldownName, uplinkTraitTime);
                            MessageScheduleApi.scheduleTranslateMessageToPlayer(player.getName(), uplinkTraitTime, "cooldown_is_ready_again", "trait_name", trait.getDisplayName());
                        }
                    }
                }
            }
            catch (Exception e) {
                if (this.spamPreventionActive) {
                    boolean bl = changedSomething;
                    this.plugin.getStatistics().eventTime(trait.getName(), System.currentTimeMillis() - timeBefore);
                    return bl;
                }
                try {
                    ++this.errorsPerMin;
                    if (this.errorsPerMin > 20) {
                        this.spamPreventionActive = true;
                        this.plugin.log("Getting too many Errors for Trait Events! Spam preventions is suppressing them all to save your log from beeing flooded!");
                    }
                    String holderName = trait.getTraitHolders() == null ? "static" : trait.getTraitHolders().toString();
                    this.plugin.getDebugLogger().logError("Error while executing trait: " + trait.getName() + " of holders: " + holderName + " event was: " + event.getEventName() + " Error was: " + e.getLocalizedMessage());
                    this.plugin.getDebugLogger().logStackTrace(e);
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.plugin.getStatistics().eventTime(trait.getName(), System.currentTimeMillis() - timeBefore);
                }
            }
            this.plugin.getStatistics().eventTime(trait.getName(), System.currentTimeMillis() - timeBefore);
        }
        this.plugin.getStatistics().eventTriggered();
        return changedSomething;
    }

    private boolean checkDisabledPerWorld(World world) {
        List<String> worldsDisabledOn = this.plugin.getConfigManager().getGeneralConfig().getConfig_worldsDisabled();
        String worldName = world == null ? "" : world.getName();
        for (String disabledWorldName : worldsDisabledOn) {
            if (!disabledWorldName.equalsIgnoreCase(worldName)) continue;
            return true;
        }
        return false;
    }

    public void cleanEventList() {
        LinkedList<Integer> toRemove = new LinkedList<Integer>();
        long currentTime = System.currentTimeMillis();
        for (Integer inT : this.eventIDs.keySet()) {
            long oldVal = this.eventIDs.get(inT);
            if (currentTime - oldVal <= 500L) continue;
            toRemove.add(inT);
        }
        for (Integer inT : toRemove) {
            this.eventIDs.remove(inT);
        }
    }

    private void registerTraitIntern(Trait trait, Set<Class<? extends Event>> events, int priority) {
        for (Class<? extends Event> clazz : events) {
            Set<Trait> traits = this.traitList.get(clazz);
            if (traits == null) {
                traits = new HashSet<Trait>();
                this.traitList.put(clazz, traits);
                EventPriority eventPriority = EventPriority.NORMAL;
                try {
                    eventPriority = EventPriority.values()[priority];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    this.plugin.getServer().getPluginManager().registerEvent(clazz, (Listener)new Listener_Proxy(), eventPriority, (EventExecutor)new Simple_event_executor(), (Plugin)this.plugin);
                    this.registeredEventsAsName.add(clazz.getCanonicalName());
                }
                catch (Exception exp) {
                    this.plugin.log("Could not register Event: " + clazz.getCanonicalName() + " of trait: " + trait.getName() + ". Exception: " + exp.getLocalizedMessage());
                    this.plugin.getDebugLogger().logStackTrace(exp);
                }
            }
            traits.add(trait);
        }
    }

    private void unregisterTraitIntern(Trait trait) {
        this.traitList.remove(trait);
    }

    public static TraitEventManager getInstance() {
        return manager;
    }

    public static boolean fireEvent(Event event) {
        try {
            long time = System.currentTimeMillis();
            boolean result = TraitEventManager.getInstance().fireEventIntern(event);
            timings += System.currentTimeMillis() - time;
            return result;
        }
        catch (Exception e) {
            RacesAndClasses.getPlugin().getDebugLogger().logStackTrace(e);
            return false;
        }
    }

    public static long timingResults() {
        long time = new Long(timings);
        timings = 0L;
        return time;
    }

    public static long getCalls() {
        long tempCalls = new Long(calls);
        calls = 0L;
        return tempCalls;
    }

    public static void registerTrait(Trait trait, Set<Class<? extends Event>> events, int priority) {
        TraitEventManager.getInstance().registerTraitIntern(trait, events, priority);
    }

    public void unregisterTrait(Trait trait) {
        TraitEventManager.getInstance().unregisterTraitIntern(trait);
    }

    public List<String> getRegisteredEventsAsName() {
        return this.registeredEventsAsName;
    }
}

