/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.entitystatusmanager.stun;

import de.tobiyas.racesandclasses.APIs.StunAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class StunReduceContainer {
    private int stunImunFactor = 0;
    private boolean tempImun = false;
    private BukkitTask task = null;
    private final Entity entity;

    public StunReduceContainer(Entity entity) {
        this.entity = entity;
    }

    public void start() {
        if (this.task == null) {
            this.task = new DebugBukkitRunnable("StunReduceTask"){

                @Override
                public void runIntern() {
                    if (StunAPI.StunEntity.getRemainingStunTimeInTicks(StunReduceContainer.this.entity) <= 0) {
                        StunReduceContainer.this.reduce();
                    }
                }
            }.runTaskTimer((Plugin)RacesAndClasses.getPlugin(), 20L, 20L);
        }
    }

    public void stop() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    public void notifyStun() {
        this.stunImunFactor += 30;
        this.stunImunFactor = Math.min(100, this.stunImunFactor);
        if (this.stunImunFactor >= 100) {
            this.tempImun = true;
        }
        this.stop();
    }

    public void notifyStunStop() {
        this.start();
    }

    public void reduce() {
        this.stunImunFactor -= 10;
        this.stunImunFactor = Math.max(0, this.stunImunFactor);
        if (this.stunImunFactor <= 0) {
            this.tempImun = false;
        }
    }

    public int getReducedTicks(int ticks) {
        if (this.tempImun) {
            return 0;
        }
        double percent = 1.0 - (double)this.stunImunFactor / 100.0;
        return (int)Math.round((double)ticks * percent);
    }
}

