/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.entitystatusmanager.stun;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.configuration.statusimun.StatusEffect;
import de.tobiyas.racesandclasses.entitystatusmanager.stun.StunReduceContainer;
import de.tobiyas.racesandclasses.eventprocessing.events.stun.PlayerStunnedEvent;
import de.tobiyas.racesandclasses.util.friend.EnemyChecker;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import de.tobiyas.util.RaC.vollotile.VollotileCodeManager;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class StunManager {
    private final int TICK_TIME = 1;
    private Map<Entity, StunOptions> stunTimes = new ConcurrentHashMap<Entity, StunOptions>();
    private Map<Entity, StunReduceContainer> stunReduces = new ConcurrentHashMap<Entity, StunReduceContainer>();
    private BukkitTask bukkitTask = null;
    private final RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public void init() {
        if (this.bukkitTask == null) {
            this.bukkitTask = new DebugBukkitRunnable("StunManagerTick"){

                @Override
                protected void runIntern() {
                    Iterator stunIt = StunManager.this.stunTimes.entrySet().iterator();
                    while (stunIt.hasNext()) {
                        Map.Entry entry = stunIt.next();
                        StunOptions options = (StunOptions)entry.getValue();
                        Entity entity = (Entity)entry.getKey();
                        int newValue = options.timeRemaining - 1;
                        if (newValue < 0 || entity.isDead()) {
                            stunIt.remove();
                            StunManager.this.notifyStunOver(entity);
                            if (!(entity instanceof Player)) continue;
                            StunManager.this.sendStunEndMessage((Player)entity);
                            continue;
                        }
                        options.timeRemaining = newValue;
                        double distanceStun = options.stunLocation.distance(entity.getLocation());
                        if (distanceStun > 0.2) {
                            entity.teleport(options.stunLocation);
                        }
                        if (!(entity instanceof LivingEntity) || newValue % 10 != 0) continue;
                        StunManager.this.playStunEffect(entity);
                    }
                }
            }.runTaskTimer((Plugin)this.plugin, 20L, 1L);
            new DebugBukkitRunnable("StunManagerRemoveOld"){

                @Override
                protected void runIntern() {
                    Iterator stunReduceIt = StunManager.this.stunReduces.entrySet().iterator();
                    while (stunReduceIt.hasNext()) {
                        Map.Entry entry = stunReduceIt.next();
                        if (((Entity)entry.getKey()).isValid()) continue;
                        ((StunReduceContainer)entry.getValue()).stop();
                        stunReduceIt.remove();
                    }
                }
            }.runTaskTimer((Plugin)RacesAndClasses.getPlugin(), 20L, 20L);
        }
    }

    protected void sendStunEndMessage(Player entity) {
        LanguageAPI.sendTranslatedMessage((CommandSender)entity, "stun_ended");
    }

    protected void playStunEffect(Entity stunnedEntity) {
        List near = stunnedEntity.getNearbyEntities(50.0, 50.0, 50.0);
        for (Entity entity : near) {
            if (!(entity instanceof Player)) continue;
            VollotileCodeManager.getVollotileCode().playCriticalHitEffect((Player)entity, stunnedEntity);
        }
    }

    public void deinit() {
        if (this.bukkitTask != null) {
            this.bukkitTask.cancel();
        }
    }

    public int getRestStunTime(Entity entity) {
        if (entity == null) {
            return -1;
        }
        if (!this.isStunned(entity)) {
            return -1;
        }
        int time = this.stunTimes.get(entity).timeRemaining;
        return time;
    }

    public boolean stunEntity(Entity stunner, Entity entity, int time) {
        if (entity == null || time <= 0) {
            return false;
        }
        if (this.isImun(entity)) {
            return false;
        }
        StunReduceContainer container = this.stunReduces.get(entity);
        if (container == null) {
            container = new StunReduceContainer(entity);
            this.stunReduces.put(entity, container);
        }
        time = container.getReducedTicks(time);
        int restTime = this.getRestStunTime(entity);
        if (restTime > time) {
            return false;
        }
        if (stunner != null && EnemyChecker.areAllies(stunner, entity)) {
            return false;
        }
        if (entity instanceof Player) {
            PlayerStunnedEvent event = new PlayerStunnedEvent((Player)entity, time);
            this.plugin.fireEventToBukkit((Event)event);
            if (event.isCancelled() || event.getTimeInTicks() <= 0) {
                return false;
            }
            time = event.getTimeInTicks();
        }
        StunOptions stunOptions = new StunOptions();
        stunOptions.stunLocation = entity.getLocation();
        stunOptions.timeRemaining = time / 1;
        this.stunTimes.put(entity, stunOptions);
        container.notifyStun();
        if (entity instanceof Player) {
            int timeInSeconds = time / 20;
            LanguageAPI.sendTranslatedMessage((CommandSender)((Player)entity), "stun_message", "time", String.valueOf(timeInSeconds));
        }
        return true;
    }

    private boolean isImun(Entity entity) {
        if (entity == null) {
            return false;
        }
        String name = entity.getCustomName();
        return this.plugin.getConfigManager().getStatusImunManager().isImun(name, StatusEffect.STUN);
    }

    public boolean removeStun(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (!this.isStunned(entity)) {
            return false;
        }
        this.stunTimes.remove(entity);
        this.notifyStunOver(entity);
        return true;
    }

    public boolean isStunned(Entity entity) {
        return this.stunTimes.containsKey(entity);
    }

    private void notifyStunOver(Entity entity) {
        StunReduceContainer container = this.stunReduces.get(entity);
        if (container == null) {
            container = new StunReduceContainer(entity);
            this.stunReduces.put(entity, container);
        }
        container.notifyStunStop();
    }

    private class StunOptions {
        private Location stunLocation;
        private int timeRemaining;

        private StunOptions() {
        }
    }
}

