/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.entitystatusmanager.silence;

import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.MagicSpellTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitWithCost;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class SilenceAndKickManager {
    private Map<UUID, Long> silenceMap = new HashMap<UUID, Long>();
    private Map<UUID, Set<MagicSpellTrait>> currentlyCastingMap = new HashMap<UUID, Set<MagicSpellTrait>>();

    public void startsChannel(UUID entityID, MagicSpellTrait spell) {
        double channelTime = spell.getChannelingTime();
        if (channelTime > 0.0) {
            Set<MagicSpellTrait> traits = this.currentlyCastingMap.get(entityID);
            if (traits == null) {
                traits = new HashSet<MagicSpellTrait>();
                this.currentlyCastingMap.put(entityID, traits);
            }
            traits.add(spell);
        }
    }

    public void endChannel(UUID entityID, TraitWithCost trait) {
        Set<MagicSpellTrait> traits = this.currentlyCastingMap.get(entityID);
        if (traits == null) {
            return;
        }
        traits.remove(traits);
    }

    public boolean isChanneling(UUID entityID) {
        Set<MagicSpellTrait> traits = this.currentlyCastingMap.get(entityID);
        if (traits != null && !traits.isEmpty()) {
            return false;
        }
        for (MagicSpellTrait trait : traits) {
            if (!trait.isKickable()) continue;
            return true;
        }
        return false;
    }

    public boolean kickChanneling(UUID entityID, long timeInMs) {
        Set<MagicSpellTrait> traits = this.currentlyCastingMap.get(entityID);
        if (traits == null || traits.isEmpty()) {
            return false;
        }
        int kicked = 0;
        Iterator<MagicSpellTrait> it = traits.iterator();
        while (it.hasNext()) {
            MagicSpellTrait trait = it.next();
            if (!trait.isKickable()) continue;
            trait.gotKicked(entityID);
            it.remove();
            ++kicked;
        }
        if (kicked > 0) {
            this.silenceMap.put(entityID, System.currentTimeMillis() + timeInMs);
        }
        return kicked > 0;
    }

    public boolean silence(UUID entityID, long timeInMs) {
        boolean interrupted = this.kickChanneling(entityID, timeInMs);
        if (!interrupted) {
            this.silenceMap.put(entityID, System.currentTimeMillis() + timeInMs);
        }
        return interrupted;
    }

    public boolean isSilenced(UUID entityID) {
        if (entityID == null || !this.silenceMap.containsKey(entityID)) {
            return false;
        }
        return System.currentTimeMillis() < this.silenceMap.get(entityID);
    }

    public long getRestSilenceTime(UUID entityID) {
        if (entityID == null || !this.silenceMap.containsKey(entityID)) {
            return 0L;
        }
        long rest = this.silenceMap.get(entityID) - System.currentTimeMillis();
        return Math.max(0L, rest);
    }
}

