/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.entitystatusmanager.hots;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.entitystatusmanager.hots.Hot;
import de.tobiyas.racesandclasses.entitystatusmanager.hots.HotContainer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class HotsManager
implements Listener {
    private final Map<UUID, HotContainer> hotContainers = new HashMap<UUID, HotContainer>();
    private final RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public HotsManager() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Iterator it = HotsManager.this.hotContainers.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    HotContainer container = (HotContainer)entry.getValue();
                    if (!container.stillValid()) {
                        it.remove();
                        continue;
                    }
                    container.tick();
                }
            }
        }, 10L, 10L);
    }

    public HotContainer get(LivingEntity entity) {
        if (!this.hotContainers.containsKey(entity.getUniqueId())) {
            this.hotContainers.put(entity.getUniqueId(), new HotContainer(entity));
        }
        return this.hotContainers.get(entity.getUniqueId());
    }

    public boolean addHot(LivingEntity entity, Hot hot) {
        HotContainer container = this.get(entity);
        return container.addHot(hot);
    }

    @EventHandler
    public void playerQuit(PlayerQuitEvent event) {
        this.hotContainers.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void playerDies(PlayerDeathEvent event) {
        HotContainer container = this.get((LivingEntity)event.getEntity());
        container.reset();
        this.hotContainers.remove(event.getEntity().getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void entityDies(EntityDeathEvent event) {
        this.hotContainers.remove(event.getEntity());
    }
}

