/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.entitystatusmanager.hots;

import de.tobiyas.racesandclasses.entitystatusmanager.hots.Hot;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.bukkit.entity.LivingEntity;

public class HotContainer {
    private final LivingEntity entity;
    private final Set<Hot> hots = new HashSet<Hot>();

    public HotContainer(LivingEntity entity) {
        this.entity = entity;
    }

    public boolean addHot(Hot toAdd) {
        this.removeInvalid();
        if (!toAdd.canStack()) {
            String id = toAdd.getId();
            for (Hot hot : this.hots) {
                if (!hot.getId().equals(id)) continue;
                return false;
            }
        }
        this.hots.add(toAdd);
        return true;
    }

    private void removeInvalid() {
        Iterator<Hot> it = this.hots.iterator();
        while (it.hasNext()) {
            if (it.next().stillValid()) continue;
            it.remove();
        }
    }

    public void tick() {
        Iterator<Hot> it = this.hots.iterator();
        while (it.hasNext()) {
            Hot hot = it.next();
            if (!hot.stillValid()) {
                it.remove();
                continue;
            }
            hot.tick();
            if (hot.stillValid()) continue;
            it.remove();
        }
    }

    public boolean stillValid() {
        return this.entity.isValid();
    }

    public void reset() {
        this.hots.clear();
    }

    public Set<Hot> getAllActiveHots() {
        this.removeInvalid();
        return new HashSet<Hot>(this.hots);
    }

    public void clearHot(String id) {
        Iterator<Hot> it = this.hots.iterator();
        while (it.hasNext()) {
            Hot hot = it.next();
            if (!hot.getId().equals(id)) continue;
            it.remove();
        }
    }

    public void clearHot(Hot hot) {
        this.hots.remove(hot);
    }
}

