/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.entitystatusmanager.dot;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.configuration.statusimun.StatusEffect;
import de.tobiyas.racesandclasses.entitystatusmanager.dot.DamageType;
import de.tobiyas.racesandclasses.entitystatusmanager.dot.DotBuilder;
import de.tobiyas.racesandclasses.entitystatusmanager.dot.DotContainer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.vollotile.ParticleContainer;
import de.tobiyas.racesandclasses.vollotile.Vollotile;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class DotManager
implements Listener {
    private final RacesAndClasses plugin;
    private BukkitTask bukkitTask;
    private final Map<LivingEntity, Collection<DotContainer>> dotDamageMap = new ConcurrentHashMap<LivingEntity, Collection<DotContainer>>();

    public DotManager() {
        this.plugin = RacesAndClasses.getPlugin();
        this.plugin.registerEvents(this);
    }

    public void init() {
        this.dotDamageMap.clear();
        if (this.bukkitTask == null) {
            this.bukkitTask = new DebugBukkitRunnable("PoisonTicker"){

                @Override
                public void runIntern() {
                    Iterator poisonTickerIterator = DotManager.this.dotDamageMap.entrySet().iterator();
                    block0: while (poisonTickerIterator.hasNext()) {
                        Map.Entry entry = poisonTickerIterator.next();
                        LivingEntity entity = (LivingEntity)entry.getKey();
                        Iterator itDots = ((Collection)entry.getValue()).iterator();
                        while (itDots.hasNext()) {
                            DotContainer dotContainer = (DotContainer)itDots.next();
                            if (entity.isDead() || !entity.isValid()) {
                                poisonTickerIterator.remove();
                                continue block0;
                            }
                            int newTicks = dotContainer.getTicks() - 1;
                            dotContainer.setTicks(newTicks);
                            if (newTicks % dotContainer.getDamageEveryTicks() == 0 && DotManager.this.damageEntity(entity, dotContainer)) {
                                DotManager.this.playDotParticleEffects(entity, dotContainer);
                            }
                            if (newTicks >= 0) continue;
                            itDots.remove();
                        }
                    }
                }
            }.runTaskTimer((Plugin)this.plugin, 5L, 5L);
        }
    }

    protected void playDotParticleEffects(LivingEntity entity, DotContainer option) {
        Location loc = entity.getLocation().clone().add(0.0, 1.0, 0.0);
        ParticleContainer effect = option.getDamageType().getParticleContainer();
        Vollotile.get().sendOwnParticleEffectToAll(effect, loc);
    }

    protected boolean damageEntity(LivingEntity entity, DotContainer options) {
        Player realDamager;
        double damagePerTick = options.getDamageOnTick();
        EntityDamageEvent event = CompatibilityModifier.EntityDamage.safeCreateEvent((Entity)entity, options.getDamageType().getCause(), damagePerTick);
        this.plugin.fireEventToBukkit((Event)event);
        RaCPlayer damager = options.getDamager();
        Player player = realDamager = damager.isOnline() ? damager.getRealPlayer() : null;
        if (!event.isCancelled()) {
            double newDamage = CompatibilityModifier.EntityDamage.safeGetDamage(event);
            CompatibilityModifier.LivingEntity.safeDamageEntityByEntity(entity, (LivingEntity)realDamager, newDamage);
        }
        return !event.isCancelled();
    }

    public void deinit() {
        if (this.bukkitTask != null) {
            this.bukkitTask.cancel();
            this.bukkitTask = null;
        }
    }

    public boolean dotEntity(LivingEntity entity, DotBuilder builder) {
        if (entity == null || !builder.valid()) {
            return false;
        }
        DamageType damageType = builder.getDamageType();
        if (this.isImun((Entity)entity, damageType)) {
            return false;
        }
        DotContainer newContainer = builder.build();
        Collection<DotContainer> dotsOfEntity = this.dotDamageMap.get(entity);
        if (dotsOfEntity == null) {
            dotsOfEntity = new HashSet<DotContainer>();
            this.dotDamageMap.put(entity, dotsOfEntity);
        }
        Iterator<DotContainer> it = dotsOfEntity.iterator();
        while (it.hasNext()) {
            DotContainer next = it.next();
            if (!next.getName().equalsIgnoreCase(newContainer.getName())) continue;
            it.remove();
        }
        dotsOfEntity.add(newContainer);
        return true;
    }

    private boolean isImun(Entity entity, DamageType type) {
        if (entity == null || type == null) {
            return false;
        }
        StatusEffect effect = null;
        switch (type) {
            case FIRE: 
            case FIRE_TICK: 
            case LAVA: {
                effect = StatusEffect.FIRE;
                break;
            }
            case POISON: {
                effect = StatusEffect.POISON;
                break;
            }
            default: {
                effect = null;
            }
        }
        String name = entity.getCustomName();
        return this.plugin.getConfigManager().getStatusImunManager().isImun(name, effect);
    }

    public int removeAllDots(LivingEntity entity) {
        if (entity == null) {
            return 0;
        }
        Collection<DotContainer> removed = this.dotDamageMap.remove(entity);
        return removed == null ? 0 : removed.size();
    }

    public int removeAllDots(LivingEntity entity, String name) {
        if (entity == null) {
            return 0;
        }
        Collection<DotContainer> containers = this.dotDamageMap.get(entity);
        if (containers == null) {
            return 0;
        }
        int removed = 0;
        Iterator<DotContainer> it = containers.iterator();
        while (it.hasNext()) {
            if (!it.next().getName().equalsIgnoreCase(name)) continue;
            it.remove();
            ++removed;
        }
        return removed;
    }

    public int removeAllDots(LivingEntity entity, DamageType type) {
        if (entity == null) {
            return 0;
        }
        Collection<DotContainer> containers = this.dotDamageMap.get(entity);
        if (containers == null) {
            return 0;
        }
        int removed = 0;
        Iterator<DotContainer> it = containers.iterator();
        while (it.hasNext()) {
            if (it.next().getDamageType() != type) continue;
            it.remove();
            ++removed;
        }
        return removed;
    }

    public Collection<DotContainer> getAllDotsOnEntity(LivingEntity entity) {
        if (entity == null) {
            return new ArrayList<DotContainer>(0);
        }
        ArrayList dots = this.dotDamageMap.get(entity);
        return dots == null ? new ArrayList(0) : dots;
    }

    public Collection<DotContainer> getAllDotsOnEntity(LivingEntity entity, DamageType type) {
        if (entity == null || type == null) {
            return new ArrayList<DotContainer>(0);
        }
        Collection<DotContainer> dots = this.getAllDotsOnEntity(entity);
        Iterator<DotContainer> it = dots.iterator();
        while (it.hasNext()) {
            if (it.next().getDamageType() == type) continue;
            it.remove();
        }
        return dots;
    }

    @EventHandler
    public void onEntityDied(EntityDeathEvent event) {
        this.dotDamageMap.remove(event.getEntity());
    }

    @EventHandler
    public void onPlayerDied(PlayerDeathEvent event) {
        this.onEntityDied((EntityDeathEvent)event);
    }
}

