/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.entitystatusmanager.dot;

import de.tobiyas.racesandclasses.entitystatusmanager.dot.DamageType;
import de.tobiyas.racesandclasses.entitystatusmanager.dot.DotContainer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;

public class DotBuilder {
    private final String name;
    private RaCPlayer damager;
    private int totalTimeInTicks = 0;
    private double totalDamage = 0.0;
    private int damageEveryTicks = 10000;
    private DamageType damageType = DamageType.MAGIC;

    public DotBuilder(String name, RaCPlayer damager) {
        this(name);
        this.damager = damager;
    }

    public DotBuilder(String name) {
        this.name = name;
    }

    public DotBuilder setTotalTimeInTicks(int totalTimeInTicks) {
        this.totalTimeInTicks = totalTimeInTicks;
        return this;
    }

    public DotBuilder setTotalTimeInSeconds(int totalTimeInSeconds) {
        return this.setTotalTimeInTicks(totalTimeInSeconds * 20);
    }

    public DotBuilder setTotalDamage(double totalDamage) {
        this.totalDamage = totalDamage;
        return this;
    }

    public DotBuilder setDamager(RaCPlayer damager) {
        this.damager = damager;
        return this;
    }

    public DotBuilder setDamageEveryTicks(int damageEveryTicks) {
        this.damageEveryTicks = damageEveryTicks;
        return this;
    }

    public DotBuilder setDamageEverySecond() {
        return this.setDamageEverySeconds(1);
    }

    public DotBuilder setDamageEverySeconds(int seconds) {
        return this.setDamageEveryTicks(seconds * 20);
    }

    public DotBuilder setDamageType(DamageType dotType) {
        this.damageType = dotType;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public RaCPlayer getDamager() {
        return this.damager;
    }

    public int getTotalTimeInTicks() {
        return this.totalTimeInTicks;
    }

    public double getTotalDamage() {
        return this.totalDamage;
    }

    public int getDamageEveryTicks() {
        return this.damageEveryTicks;
    }

    public DamageType getDamageType() {
        return this.damageType;
    }

    public boolean valid() {
        if (this.name == null || this.name.isEmpty()) {
            return false;
        }
        if (this.damageEveryTicks <= 0) {
            return false;
        }
        if (this.damageType == null) {
            return false;
        }
        if (this.totalDamage <= 0.0) {
            return false;
        }
        return this.totalTimeInTicks > 0;
    }

    public DotBuilder copy() {
        return new DotBuilder(this.name, this.damager).setDamageEveryTicks(this.damageEveryTicks).setDamageType(this.damageType).setTotalDamage(this.totalDamage).setTotalTimeInTicks(this.totalTimeInTicks);
    }

    public DotContainer build() {
        if (!this.valid()) {
            return null;
        }
        int realTicks = this.totalTimeInTicks / 5;
        int realdamageEveryTicks = this.damageEveryTicks / 5;
        double damageOnTick = this.totalDamage / (double)this.totalTimeInTicks * (double)this.damageEveryTicks;
        return new DotContainer(this.name, this.damager, this.damageType, realTicks, damageOnTick, realdamageEveryTicks);
    }
}

