/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.entitystatusmanager.dot;

import de.tobiyas.racesandclasses.vollotile.ParticleContainer;
import de.tobiyas.racesandclasses.vollotile.ParticleEffects;
import de.tobiyas.util.RaC.math.Levenshtein;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.util.Vector;

public enum DamageType {
    POISON(new ParticleContainer(ParticleEffects.STEP_SOUND, new Vector(0.0, 0.1, 0.0), 10, 133.0f), EntityDamageEvent.DamageCause.POISON, "damage_poison"),
    FIRE(new ParticleContainer(ParticleEffects.FLAME, new Vector(0.0, 0.1, 0.0), 10, 0.0f), EntityDamageEvent.DamageCause.FIRE, "damage_fire"),
    MAGIC(new ParticleContainer(ParticleEffects.WITCH_MAGIC, new Vector(0.0, 0.1, 0.0), 10, 0.0f), EntityDamageEvent.DamageCause.MAGIC, "damage_magic"),
    BLEEDING(new ParticleContainer(ParticleEffects.STEP_SOUND, new Vector(0.0, 0.1, 0.0), 10, 152.0f), EntityDamageEvent.DamageCause.SUFFOCATION, "damage_suffocation"),
    CONTACT(new ParticleContainer(ParticleEffects.STEP_SOUND, new Vector(0.0, 0.1, 0.0), 10, 152.0f), EntityDamageEvent.DamageCause.CONTACT, "damage_contact"),
    ENTITY_ATTACK(new ParticleContainer(ParticleEffects.STEP_SOUND, new Vector(0.0, 0.1, 0.0), 10, 152.0f), EntityDamageEvent.DamageCause.ENTITY_ATTACK, "damage_entity_attack"),
    PROJECTILE(new ParticleContainer(ParticleEffects.STEP_SOUND, new Vector(0.0, 0.1, 0.0), 10, 152.0f), EntityDamageEvent.DamageCause.PROJECTILE, "damage_projectile"),
    SUFFOCATION(new ParticleContainer(ParticleEffects.STEP_SOUND, new Vector(0.0, 0.1, 0.0), 10, 152.0f), EntityDamageEvent.DamageCause.SUFFOCATION, "damage_suffocation"),
    FALL(new ParticleContainer(ParticleEffects.STEP_SOUND, new Vector(0.0, 0.1, 0.0), 10, 152.0f), EntityDamageEvent.DamageCause.FALL, "damage_fall"),
    FIRE_TICK(new ParticleContainer(ParticleEffects.STEP_SOUND, new Vector(0.0, 0.1, 0.0), 10, 152.0f), EntityDamageEvent.DamageCause.FIRE_TICK, "damage_fire_tick"),
    MELTING(new ParticleContainer(ParticleEffects.STEP_SOUND, new Vector(0.0, 0.1, 0.0), 10, 152.0f), EntityDamageEvent.DamageCause.MELTING, "damage_melting"),
    LAVA(new ParticleContainer(ParticleEffects.STEP_SOUND, new Vector(0.0, 0.1, 0.0), 10, 152.0f), EntityDamageEvent.DamageCause.LAVA, "damage_lava"),
    DROWNING(new ParticleContainer(ParticleEffects.STEP_SOUND, new Vector(0.0, 0.1, 0.0), 10, 152.0f), EntityDamageEvent.DamageCause.DROWNING, "damage_drowning"),
    BLOCK_EXPLOSION(new ParticleContainer(ParticleEffects.STEP_SOUND, new Vector(0.0, 0.1, 0.0), 10, 152.0f), EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, "damage_block_explosion"),
    ENTITY_EXPLOSION(new ParticleContainer(ParticleEffects.STEP_SOUND, new Vector(0.0, 0.1, 0.0), 10, 152.0f), EntityDamageEvent.DamageCause.ENTITY_EXPLOSION, "damage_entity_explosion"),
    VOID(new ParticleContainer(ParticleEffects.STEP_SOUND, new Vector(0.0, 0.1, 0.0), 10, 152.0f), EntityDamageEvent.DamageCause.VOID, "damage_void"),
    LIGHTNING(new ParticleContainer(ParticleEffects.STEP_SOUND, new Vector(0.0, 0.1, 0.0), 10, 152.0f), EntityDamageEvent.DamageCause.LIGHTNING, "damage_lightning"),
    SUICIDE(new ParticleContainer(ParticleEffects.STEP_SOUND, new Vector(0.0, 0.1, 0.0), 10, 152.0f), EntityDamageEvent.DamageCause.SUICIDE, "damage_suicide"),
    STARVATION(new ParticleContainer(ParticleEffects.STEP_SOUND, new Vector(0.0, 0.1, 0.0), 10, 152.0f), EntityDamageEvent.DamageCause.STARVATION, "damage_starvation"),
    WITHER(new ParticleContainer(ParticleEffects.STEP_SOUND, new Vector(0.0, 0.1, 0.0), 10, 152.0f), EntityDamageEvent.DamageCause.WITHER, "damage_wither"),
    FALLING_BLOCK(new ParticleContainer(ParticleEffects.STEP_SOUND, new Vector(0.0, 0.1, 0.0), 10, 152.0f), EntityDamageEvent.DamageCause.FALLING_BLOCK, "damage_falling_block"),
    THORNS(new ParticleContainer(ParticleEffects.STEP_SOUND, new Vector(0.0, 0.1, 0.0), 10, 152.0f), EntityDamageEvent.DamageCause.THORNS, "damage_thorns"),
    CUSTOM(new ParticleContainer(ParticleEffects.STEP_SOUND, new Vector(0.0, 0.1, 0.0), 10, 152.0f), EntityDamageEvent.DamageCause.CUSTOM, "damage_custom");

    private final ParticleContainer container;
    private final EntityDamageEvent.DamageCause cause;
    private final String nameKey;

    private DamageType(ParticleContainer container, EntityDamageEvent.DamageCause cause, String nameKey) {
        this.container = container;
        this.cause = cause;
        this.nameKey = nameKey;
    }

    public ParticleContainer getParticleContainer() {
        return this.container;
    }

    public EntityDamageEvent.DamageCause getCause() {
        return this.cause;
    }

    public String getNameKey() {
        return this.nameKey;
    }

    public static DamageType parse(String name) {
        DamageType[] damageTypeArray = DamageType.values();
        int n = damageTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DamageType type = damageTypeArray[n2];
            if (name.equalsIgnoreCase(type.name())) {
                return type;
            }
            if (name.equalsIgnoreCase(type.getCause().name())) {
                return type;
            }
            ++n2;
        }
        DamageType nearest = Levenshtein.getNearestIgnoreCase(name, DamageType.values());
        return nearest == null ? FIRE : nearest;
    }
}

