/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.entitystatusmanager.debuff;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.entitystatusmanager.debuff.Debuff;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class DebuffManager {
    private final int TICKS_PER_TICK = 10;
    private final Set<Debuff> debuffs = new HashSet<Debuff>();
    private BukkitTask task;

    public void shutdown() {
        this.debuffs.clear();
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    public void init() {
        this.debuffs.clear();
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        this.task = new DebugBukkitRunnable("DebuffTick"){

            @Override
            protected void runIntern() {
                if (DebuffManager.this.debuffs.isEmpty()) {
                    return;
                }
                DebuffManager.this.tick();
            }
        }.runTaskTimer((Plugin)RacesAndClasses.getPlugin(), 10L, 10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Debuff> getAllDebuffs(UUID id) {
        HashSet<Debuff> idDebuffs = new HashSet<Debuff>();
        Set<Debuff> set = this.debuffs;
        synchronized (set) {
            for (Debuff debuff : this.debuffs) {
                if (!debuff.getEntityID().equals(id)) continue;
                idDebuffs.add(debuff);
            }
        }
        return idDebuffs;
    }

    public void register(Debuff debuff) {
        for (Debuff toCheck : this.debuffs) {
            if (!toCheck.getDisplayName().equals(debuff)) continue;
            this.debuffs.remove(toCheck);
            break;
        }
        this.debuffs.add(debuff);
    }

    public void cancel(Debuff toCancel) {
        for (Debuff debuff : this.debuffs) {
            if (debuff != toCancel) continue;
            this.debuffs.remove(debuff);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tick() {
        Set<Debuff> set = this.debuffs;
        synchronized (set) {
            Iterator<Debuff> it = this.debuffs.iterator();
            block3: while (it.hasNext()) {
                int i = 0;
                while (i < 10) {
                    Debuff next = it.next();
                    next.tick();
                    if (next.done()) {
                        it.remove();
                        continue block3;
                    }
                    ++i;
                }
            }
        }
    }
}

