/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.entitystatusmanager.debuff;

import java.util.UUID;

public abstract class Debuff {
    protected final int totalTicks;
    protected int ticksDone = 0;
    protected final int tickPeriod;
    protected int currentTick = 0;
    protected final UUID entityID;
    protected final String displayName;

    public Debuff(String displayName, int totalTicks, int tickPeriod, UUID entityID) {
        this.displayName = displayName;
        this.totalTicks = totalTicks;
        this.tickPeriod = tickPeriod;
        this.entityID = entityID;
    }

    public UUID getEntityID() {
        return this.entityID;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getsecondsLeft() {
        double left = this.totalTicks - this.ticksDone;
        return (int)Math.round((left *= (double)this.tickPeriod) / 20.0);
    }

    public void tick() {
        ++this.currentTick;
        if (this.currentTick > this.tickPeriod) {
            this.currentTick = 0;
            this.realTick();
            ++this.ticksDone;
        }
    }

    public boolean done() {
        return this.ticksDone > this.totalTicks;
    }

    protected abstract void realTick();

    public double modifyIncomingDamage(double value) {
        return value;
    }

    public double modifyOutgoingDamage(double value) {
        return value;
    }
}

