/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.entitystatusmanager.buffs;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.entitystatusmanager.buffs.BuffContainer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;

public class BuffManager
implements Listener {
    private final Map<UUID, Set<BuffContainer>> buffMap = new HashMap<UUID, Set<BuffContainer>>();

    public BuffManager() {
        RacesAndClasses.getPlugin().registerEvents(this);
    }

    public void init() {
        this.buffMap.clear();
    }

    public Set<BuffContainer> get(UUID id) {
        Set<BuffContainer> buffs = this.buffMap.get(id);
        if (buffs == null) {
            buffs = new HashSet<BuffContainer>();
            this.buffMap.put(id, buffs);
            return buffs;
        }
        Iterator<BuffContainer> it = buffs.iterator();
        long now = System.currentTimeMillis();
        while (it.hasNext()) {
            if (it.next().getEnds() >= now) continue;
            it.remove();
        }
        return buffs;
    }

    public void addBuff(UUID id, String name, long endTime) {
        Set<BuffContainer> buffs = this.get(id);
        this.removedOrUsedBuff(id, name);
        buffs.add(new BuffContainer(endTime, name));
    }

    public void removedOrUsedBuff(UUID id, String name) {
        Set<BuffContainer> buffs = this.get(id);
        for (BuffContainer container : buffs) {
            if (!name.equals(container.getName())) continue;
            buffs.remove(container);
            break;
        }
    }

    @EventHandler
    public void playerDied(PlayerDeathEvent event) {
        this.buffMap.remove(event.getEntity().getUniqueId());
    }
}

