/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race.reminder;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class RaceReminder
extends DebugBukkitRunnable {
    private RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public RaceReminder() {
        super("RaceReminder");
        int reminderTime = this.plugin.getConfigManager().getGeneralConfig().getConfig_reminder_interval() * 20 * 60;
        this.runTaskTimer((Plugin)this.plugin, reminderTime, reminderTime);
    }

    @Override
    protected void runIntern() {
        if (this.plugin.getConfigManager().getGeneralConfig().isConfig_activate_reminder()) {
            AbstractTraitHolder defaultContainer = this.plugin.getRaceManager().getDefaultHolder();
            List<RaCPlayer> list = this.plugin.getRaceManager().getAllPlayersOfHolder(defaultContainer);
            for (RaCPlayer player : list) {
                if (player == null || !player.isOnline()) continue;
                this.postSelectRace(player);
            }
        }
    }

    private boolean hasAnyRacePermission(RaCPlayer player) {
        if (!this.plugin.getConfigManager().getGeneralConfig().isConfig_usePermissionsForRaces()) {
            return true;
        }
        String name = null;
        OfflinePlayer[] offlinePlayerArray = Bukkit.getOfflinePlayers();
        int n = offlinePlayerArray.length;
        int n2 = 0;
        while (n2 < n) {
            OfflinePlayer offlinePlayer = offlinePlayerArray[n2];
            if (offlinePlayer.getUniqueId().equals(player)) {
                name = offlinePlayer.getName();
                break;
            }
            ++n2;
        }
        if (name == null) {
            return false;
        }
        if (this.plugin.getPermissionManager().checkPermissionsSilent(name, "RaC.races.*")) {
            return true;
        }
        for (String raceName : this.plugin.getRaceManager().listAllVisibleHolders()) {
            if (!this.plugin.getPermissionManager().checkPermissionsSilent(name, "RaC.races." + raceName)) continue;
            return true;
        }
        return false;
    }

    private void postSelectRace(RaCPlayer player) {
        if (!player.isOnline()) {
            return;
        }
        if (!this.hasAnyRacePermission(player)) {
            return;
        }
        boolean useGui = this.plugin.getConfigManager().getGeneralConfig().isConfig_useRaceGUIToSelect();
        if (player != null) {
            player.sendMessage(ChatColor.YELLOW + "[PRIVATE-INFO]: You have not selected a race.");
            player.sendMessage(ChatColor.YELLOW + "[PRIVATE-INFO]: Use " + ChatColor.RED + "/race select " + (useGui ? "" : "<racename>") + " " + ChatColor.YELLOW + "to select a race.");
            player.sendMessage(ChatColor.YELLOW + "[PRIVATE-INFO]: To see all races use: " + ChatColor.LIGHT_PURPLE + "/race list");
        }
    }
}

