/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race;

import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractHolderManager;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.DefaultContainer;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.PlayerHolderAssociation;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.permissionsettings.PermissionRegisterer;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race.RaceContainer;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race.reminder.RaceReminder;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.HolderSelectedEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.raceevent.AfterRaceChangedEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.raceevent.AfterRaceSelectedEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.saving.PlayerSavingData;
import de.tobiyas.racesandclasses.util.consts.Consts;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import de.tobiyas.util.RaC.player.PlayerUtils;
import java.util.Collection;
import org.bukkit.entity.Player;

public class RaceManager
extends AbstractHolderManager {
    public RaceManager() {
        super(Consts.racesYML, "races");
        new RaceReminder();
    }

    @Override
    public void init() {
        DefaultContainer.createSTDRaces();
        super.init();
        this.checkForPossiblyWrongInitialized();
    }

    private void checkForPossiblyWrongInitialized() {
        Collection<Player> players = PlayerUtils.getOnlinePlayers();
        for (Player bPlayer : players) {
            RaCPlayer player = RaCPlayerManager.get().getPlayer(bPlayer);
            RaceContainer container = player.getRace();
            if (container == null) {
                this.addPlayerToHolder(player, Consts.defaultRace, false);
                container = player.getRace();
            }
            container.editTABListEntry(player);
        }
        for (RaCPlayer player : this.memberList.keySet()) {
            if (this.memberList.get(player) != null) continue;
            this.addPlayerToHolder(player, Consts.defaultRace, false);
        }
    }

    @Override
    protected AbstractTraitHolder generateTraitHolder(YAMLConfigExtended traitHolderConfig, String holderName) {
        return RaceContainer.loadRace(traitHolderConfig, holderName);
    }

    @Override
    protected String getConfigPrefix() {
        return "race";
    }

    @Override
    public AbstractTraitHolder getDefaultHolder() {
        return this.getHolderByName(Consts.defaultRace);
    }

    @Override
    protected void initDefaultHolder() {
        this.traitHolderList.add(RaceContainer.generateSTDRace());
    }

    @Override
    public boolean changePlayerHolder(RaCPlayer player, String newHolderName, boolean callEvent) {
        if (this.getHolderByName(newHolderName) == null) {
            return false;
        }
        String oldRace = this.getHolderOfPlayer(player).getDisplayName();
        PermissionRegisterer.removePlayer(player, this.getContainerTypeAsString());
        this.memberList.remove(player);
        if (this.plugin.getConfigManager().getGeneralConfig().isConfig_channels_enable()) {
            this.plugin.getChannelManager().playerLeaveRace(oldRace, player);
        }
        if (this.addPlayerToHolder(player, newHolderName, false)) {
            HolderSelectedEvent event;
            if (callEvent && (event = this.generateAfterChangeEvent(player, this.getHolderByName(newHolderName), this.getHolderByName(oldRace))) != null) {
                this.plugin.fireEventToBukkit(event);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addPlayerToHolder(RaCPlayer player, String newHolderName, boolean callEvent) {
        boolean worked = super.addPlayerToHolder(player, newHolderName, callEvent);
        if (worked) {
            AbstractTraitHolder holder = this.getHolderOfPlayer(player);
            if (holder instanceof RaceContainer) {
                ((RaceContainer)holder).editTABListEntry(player);
            }
            if (this.plugin.getConfigManager().getGeneralConfig().isConfig_channels_enable()) {
                this.plugin.getChannelManager().playerJoinRace(holder.getDisplayName(), player);
            }
        }
        return worked;
    }

    @Override
    public String getContainerTypeAsString() {
        return "race";
    }

    @Override
    protected String getCorrectFieldFromDBHolder(PlayerHolderAssociation container) {
        return container.getRaceName();
    }

    @Override
    protected void saveContainerToDBField(PlayerHolderAssociation container, String name) {
        container.setRaceName(name);
    }

    @Override
    protected HolderSelectedEvent generateAfterSelectEvent(RaCPlayer player, AbstractTraitHolder newHolder) {
        return new AfterRaceSelectedEvent(player.getPlayer(), (RaceContainer)newHolder);
    }

    @Override
    protected AbstractTraitHolder getStartingHolder() {
        String race = this.plugin.getConfigManager().getGeneralConfig().getConfig_takeRaceWhenNoRace();
        if (race == null || "".equals(race)) {
            return this.getDefaultHolder();
        }
        AbstractTraitHolder holder = this.getHolderByName(race);
        return holder != null ? holder : this.getDefaultHolder();
    }

    @Override
    protected HolderSelectedEvent generateAfterChangeEvent(RaCPlayer player, AbstractTraitHolder newHolder, AbstractTraitHolder oldHolder) {
        return new AfterRaceChangedEvent(player.getPlayer(), (RaceContainer)newHolder, (RaceContainer)oldHolder);
    }

    @Override
    protected AbstractTraitHolder getHolder(PlayerSavingData data) {
        return this.getHolderByName(data.getRaceName());
    }

    @Override
    protected void saveToContainer(PlayerSavingData data, AbstractTraitHolder holder) {
        data.setRaceName(holder.getDisplayName());
    }
}

