/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractHolderManager;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.exceptions.HolderConfigParseException;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.TraitStore;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.util.consts.Consts;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import de.tobiyas.util.RaC.vollotile.VollotileCode;
import de.tobiyas.util.RaC.vollotile.VollotileCodeManager;
import java.util.HashSet;

public class RaceContainer
extends AbstractTraitHolder {
    protected String raceChatColor;
    protected String raceChatFormat;

    protected RaceContainer(YAMLConfigExtended config, String name) {
        super(config, name);
    }

    protected RaceContainer(String name) {
        super(new YAMLConfigExtended(Consts.racesYML), name);
    }

    @Override
    protected void readConfigSection() throws HolderConfigParseException {
        super.readConfigSection();
        try {
            this.raceChatColor = this.config.getString(String.valueOf(this.configNodeName) + ".config.chat.color", RacesAndClasses.getPlugin().getConfigManager().getChannelConfig().getConfig_racechat_default_color());
            this.raceChatFormat = this.config.getString(String.valueOf(this.configNodeName) + ".config.chat.format", RacesAndClasses.getPlugin().getConfigManager().getChannelConfig().getConfig_racechat_default_format());
        }
        catch (Exception exp) {
            throw new HolderConfigParseException();
        }
        this.holderTag = this.config.getString(String.valueOf(this.configNodeName) + ".config.racetag", this.holderTag);
    }

    @Override
    protected void addSTDTraits() {
        Trait normalArrow = TraitStore.buildTraitByName("NormalArrow", this);
        normalArrow.addTraitHolder(this);
        this.traits.add(normalArrow);
    }

    public static RaceContainer loadRace(YAMLConfigExtended config, String name) {
        RaceContainer container = new RaceContainer(config, name);
        return container;
    }

    @Override
    public boolean containsPlayer(RaCPlayer player) {
        AbstractTraitHolder container = RacesAndClasses.getPlugin().getRaceManager().getHolderOfPlayer(player);
        if (container == null) {
            return false;
        }
        return container.getDisplayName().equals(this.configNodeName);
    }

    public void editTABListEntry(RaCPlayer player) {
        if (player == null) {
            return;
        }
        if (!RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().isConfig_adaptListName()) {
            return;
        }
        String total = String.valueOf(this.holderTag) + player.getName();
        boolean isMc1_8 = VollotileCodeManager.getVollotileCode().getVersion().isVersionGreaterOrEqual(VollotileCode.MCVersion.v1_8_R1);
        if (!isMc1_8 && total.length() > 16) {
            total = total.substring(0, 15);
        }
        player.getPlayer().setPlayerListName(total);
    }

    public String getRaceChatColor() {
        return this.raceChatColor;
    }

    public String getRaceChatFormat() {
        return this.raceChatFormat;
    }

    public static RaceContainer generateSTDRace() {
        String defaultName = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().getConfig_defaultRaceName();
        String defaultTag = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().getConfig_defaultRaceTag();
        String holderName = Consts.defaultRace = defaultName;
        RaceContainer container = new RaceContainer(null, holderName);
        container.holderTag = defaultTag;
        container.raceChatColor = "";
        container.raceChatFormat = "";
        container.armorUsage.clear();
        container.traits = new HashSet();
        container.addSTDTraits();
        return container;
    }

    @Override
    protected String getContainerTypeAsString() {
        return "race";
    }

    @Override
    public AbstractHolderManager getHolderManager() {
        return RacesAndClasses.getPlugin().getRaceManager();
    }
}

