/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.permissionsettings;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.permissionsettings.HolderPermissions;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.util.RaC.player.PlayerUtils;
import java.util.Map;
import java.util.Set;
import net.milkbowl.vault.permission.Permission;
import org.anjocaido.groupmanager.GroupManager;
import org.anjocaido.groupmanager.data.Group;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class PermissionRegisterer
implements Runnable {
    private final Set<AbstractTraitHolder> traitHolderList;
    private final Map<RaCPlayer, AbstractTraitHolder> memberList;
    private final String typeName;
    private Permission vaultPermissions;
    private static String permissionSpecificPrefix = "";

    public PermissionRegisterer(Set<AbstractTraitHolder> traitHolderList, Map<RaCPlayer, AbstractTraitHolder> memberList, String typeName) {
        this.traitHolderList = traitHolderList;
        this.memberList = memberList;
        this.typeName = typeName;
    }

    @Override
    public void run() {
        if (!PermissionRegisterer.isVaultActive()) {
            return;
        }
        this.vaultPermissions = PermissionRegisterer.checkVault();
        if (this.traitHolderList == null || this.traitHolderList.size() <= 0) {
            return;
        }
        if (this.vaultPermissions == null) {
            return;
        }
        if (!this.vaultPermissions.hasGroupSupport()) {
            return;
        }
        this.checkForSpecificPrefix();
        this.removeAllGroupsWithPrefix();
        this.registerTraitHolders();
        this.giveMembersAccessToGroups();
    }

    private void checkForSpecificPrefix() {
        if ("GroupManager".equals(this.vaultPermissions.getName())) {
            permissionSpecificPrefix = "g:";
        }
    }

    private void removeAllGroupsWithPrefix() {
        String[] groupNames;
        String[] stringArray = groupNames = this.vaultPermissions.getGroups();
        int n = groupNames.length;
        int n2 = 0;
        while (n2 < n) {
            String groupName = stringArray[n2];
            if (groupName.toLowerCase().startsWith(String.valueOf(this.typeName.toLowerCase()) + "-")) {
                OfflinePlayer[] offlinePlayerArray = Bukkit.getOfflinePlayers();
                int n3 = offlinePlayerArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    OfflinePlayer offlinePlayer = offlinePlayerArray[n4];
                    this.vaultPermissions.playerRemoveGroup(null, offlinePlayer, String.valueOf(permissionSpecificPrefix) + groupName);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void registerTraitHolders() {
        if (this.traitHolderList == null || this.traitHolderList.isEmpty()) {
            return;
        }
        for (AbstractTraitHolder holder : this.traitHolderList) {
            HolderPermissions permissions = holder.getPermissions();
            if (permissions == null || permissions.getPermissions().size() == 0) continue;
            String groupName = permissions.getGroupIdentificationName();
            this.precreateGroupIfNotExist(groupName);
            for (String permission : permissions.getPermissions()) {
                if (this.vaultPermissions.groupAdd(null, String.valueOf(permissionSpecificPrefix) + groupName, permission)) continue;
                RacesAndClasses.getPlugin().getDebugLogger().logWarning("Could NOT Register Group: " + permissionSpecificPrefix + groupName + " Permission: " + permission + ". Used: " + this.vaultPermissions.getName());
            }
        }
    }

    private void precreateGroupIfNotExist(String groupName) {
        if ("GroupManager".equals(this.vaultPermissions.getName()) && !GroupManager.getGlobalGroups().hasGroup(String.valueOf(permissionSpecificPrefix) + groupName)) {
            Group newGroup = new Group(String.valueOf(permissionSpecificPrefix) + groupName);
            GroupManager.getGlobalGroups().newGroup(newGroup);
        }
    }

    private void giveMembersAccessToGroups() {
        if (this.memberList == null || this.memberList.isEmpty()) {
            return;
        }
        for (RaCPlayer member : this.memberList.keySet()) {
            String[] groups;
            AbstractTraitHolder holder = this.memberList.get(member);
            if (holder == null) continue;
            String groupName = holder.getPermissions().getGroupIdentificationName();
            String name = member.getName();
            if (name == null || (groups = this.vaultPermissions.getPlayerGroups(null, name)) == null || groups.length == 0) continue;
            String[] stringArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                String group = stringArray[n2];
                if (group.startsWith(String.valueOf(permissionSpecificPrefix) + this.typeName)) {
                    this.vaultPermissions.playerRemoveGroup(null, name, String.valueOf(permissionSpecificPrefix) + group);
                    RacesAndClasses.getPlugin().getPermissionManager().removeSubgroup(PlayerUtils.getOfflinePlayer(name), String.valueOf(permissionSpecificPrefix) + group);
                }
                ++n2;
            }
            RacesAndClasses.getPlugin().getPermissionManager().addSubgroup(PlayerUtils.getOfflinePlayer(name), String.valueOf(permissionSpecificPrefix) + groupName);
        }
    }

    private static boolean isVaultActive() {
        block4: {
            boolean isPresent = RacesAndClasses.getPlugin().getServer().getPluginManager().isPluginEnabled("Vault");
            if (isPresent) break block4;
            return false;
        }
        try {
            RegisteredServiceProvider rsp = RacesAndClasses.getPlugin().getServer().getServicesManager().getRegistration(Permission.class);
            Permission perms = (Permission)rsp.getProvider();
            return perms.hasGroupSupport();
        }
        catch (NoSuchMethodError exp) {
            return false;
        }
        catch (Exception exp) {
            return false;
        }
    }

    private static Permission checkVault() {
        block4: {
            if (PermissionRegisterer.isVaultActive()) break block4;
            return null;
        }
        try {
            RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Permission.class);
            Permission perms = (Permission)rsp.getProvider();
            return perms.hasGroupSupport() ? perms : null;
        }
        catch (NoSuchMethodError exp) {
            return null;
        }
        catch (Exception exp) {
            return null;
        }
    }

    public static void removePlayer(RaCPlayer racPlayer, String prefix) {
        if (!PermissionRegisterer.isVaultActive()) {
            return;
        }
        Player player = racPlayer.getPlayer();
        Permission vaultPermissions = PermissionRegisterer.checkVault();
        if (vaultPermissions != null) {
            String[] groupNames = vaultPermissions.getPlayerGroups(player);
            if (groupNames == null) {
                return;
            }
            String[] stringArray = groupNames;
            int n = groupNames.length;
            int n2 = 0;
            while (n2 < n) {
                String groupName = stringArray[n2];
                if (groupName.startsWith(String.valueOf(permissionSpecificPrefix) + prefix + "-")) {
                    vaultPermissions.playerRemoveGroup(player, String.valueOf(permissionSpecificPrefix) + groupName);
                }
                ++n2;
            }
        }
    }

    public static void addPlayer(RaCPlayer player, String groupName) {
        RacesAndClasses.getPlugin().getPermissionManager().addSubgroup(PlayerUtils.getOfflinePlayer(player.getName()), String.valueOf(permissionSpecificPrefix) + groupName);
    }
}

