/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.loadingerrors;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.exceptions.HolderTraitParseException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;

public class TraitHolderLoadingErrorHandler {
    private static final RacesAndClasses plugin = RacesAndClasses.getPlugin();
    private final List<String> raceProblemMessages = new LinkedList<String>();
    private final List<String> classProblemMessages = new LinkedList<String>();

    public void rescanErrors() {
        this.raceProblemMessages.clear();
        this.classProblemMessages.clear();
        this.rescanRaceErrors();
        this.rescanClassErrors();
    }

    private void rescanRaceErrors() {
        List<String> holders = plugin.getRaceManager().listAllVisibleHolders();
        for (String holderName : holders) {
            List<HolderTraitParseException> messages;
            AbstractTraitHolder holder = plugin.getRaceManager().getHolderByName(holderName);
            if (holder == null || (messages = holder.getParsingExceptionsHappened()).size() == 0) continue;
            for (HolderTraitParseException exp : messages) {
                this.raceProblemMessages.add(exp.getMessage());
            }
        }
    }

    private void rescanClassErrors() {
        List<String> holders = plugin.getClassManager().listAllVisibleHolders();
        for (String holderName : holders) {
            List<HolderTraitParseException> messages;
            AbstractTraitHolder holder = plugin.getClassManager().getHolderByName(holderName);
            if (holder == null || (messages = holder.getParsingExceptionsHappened()).size() == 0) continue;
            for (HolderTraitParseException exp : messages) {
                this.classProblemMessages.add(exp.getMessage());
            }
        }
    }

    public void saveErrorsToFile(File file) {
        if (this.raceProblemMessages.size() <= 0 && this.classProblemMessages.size() <= 0) {
            return;
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException exp) {
                plugin.getDebugLogger().logWarning("Could not create " + file.getAbsolutePath() + " for Startup Error logging.");
                return;
            }
        }
        try {
            PrintWriter writer = new PrintWriter(file, "UTF-8");
            writer.println("Errors occured on Startup While reading Races / Classes:");
            if (this.raceProblemMessages.size() > 0) {
                writer.println();
                writer.println();
                writer.println("Race errors:");
                writer.println();
                for (String message : this.raceProblemMessages) {
                    writer.println(message);
                }
            }
            if (this.classProblemMessages.size() > 0) {
                writer.println();
                writer.println();
                writer.println("Class errors:");
                writer.println();
                for (String message : this.classProblemMessages) {
                    writer.println(message);
                }
            }
            writer.close();
        }
        catch (Exception exp) {
            plugin.getDebugLogger().logWarning("Could not write to: " + file.getAbsolutePath() + " for Startup Error logging." + " Error was: " + exp.getLocalizedMessage());
            plugin.getDebugLogger().logStackTrace(exp);
            return;
        }
    }

    public void saveErrorsToFile() {
        File file = new File(plugin.getDataFolder() + File.separator + "HolderStartupErrors.log");
        if (file.exists()) {
            file.delete();
        }
        if (this.classProblemMessages.size() == 0 && this.raceProblemMessages.size() == 0) {
            return;
        }
        try {
            file.createNewFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.saveErrorsToFile(file);
    }

    public void rescanAndSave() {
        this.rescanErrors();
        this.saveErrorsToFile();
    }

    public boolean hasErrors() {
        return this.classProblemMessages.size() > 0 || this.raceProblemMessages.size() > 0;
    }

    public static boolean evalAndSave() {
        TraitHolderLoadingErrorHandler errorHandler = new TraitHolderLoadingErrorHandler();
        errorHandler.rescanAndSave();
        return errorHandler.hasErrors();
    }
}

