/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.gui;

import de.tobiyas.racesandclasses.APIs.LevelAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.TraitHolderCombinder;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.playermanagement.skilltree.PlayerSkillTreeManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitWithRestrictions;
import de.tobiyas.util.RaC.formating.StringFormatUtils;
import de.tobiyas.util.RaC.inventorymenu.BasicSelectionInterface;
import de.tobiyas.util.RaC.items.ItemUtils;
import de.tobiyas.util.RaC.math.Math2;
import de.tobiyas.util.RaC.vollotile.VollotileCode;
import de.tobiyas.util.RaC.vollotile.VollotileCodeManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class SkillTreeGui
extends BasicSelectionInterface {
    private final RaCPlayer racPlayer;
    private final Map<Trait, ItemStack> buttons = new HashMap<Trait, ItemStack>();
    private final Map<Trait, Integer> toApply = new HashMap<Trait, Integer>();
    private final ItemStack applyItem;
    private final ItemStack discardItem;
    private int tempFreePointsToRemove = 0;
    private boolean somethingChanged = false;

    public SkillTreeGui(Player player) {
        super(player, null, Bukkit.createInventory((InventoryHolder)player, (int)54, (String)(ChatColor.RED + "Skill Tree")), (Inventory)player.getInventory(), (JavaPlugin)RacesAndClasses.getPlugin());
        this.racPlayer = RaCPlayerManager.get().getPlayer(player);
        this.applyItem = this.generateItem(Material.WOOL, (short)DyeColor.GREEN.getWoolData(), ChatColor.GREEN + "Apply", ChatColor.AQUA + "Applies the changes");
        this.discardItem = this.generateItem(Material.WOOL, (short)DyeColor.RED.getWoolData(), ChatColor.RED + "Discard", ChatColor.AQUA + "Discards the changes");
        this.toApply.putAll(this.racPlayer.getSkillTreeManager().getTraitsWithLevels());
        this.redraw();
    }

    private void redraw() {
        this.getTopInventory().clear();
        this.buttons.clear();
        int freePoints = this.racPlayer.getSkillTreeManager().getFreeSkillpoints() - this.tempFreePointsToRemove;
        int level = LevelAPI.getCurrentLevel(this.racPlayer);
        Set<Trait> allTraits = TraitHolderCombinder.getAllTraitsOfPlayer(this.racPlayer);
        Collection<Trait> permanent = this.getPermanent(allTraits);
        allTraits.removeAll(permanent);
        Collection<Trait> filtered = this.filterForExclusions(allTraits);
        for (Trait trait : filtered) {
            int slot = trait.getSkillTreePlace();
            if (slot < 0 || slot >= this.getTopInventory().getSize()) continue;
            ItemStack item = this.generateItemForTrait(trait, this.toApply, level, freePoints);
            ItemStack oldItem = this.getTopInventory().getItem(slot);
            if (oldItem != null && oldItem.getType() != Material.AIR) {
                RacesAndClasses.getPlugin().logWarning("Warning: in the Skilltree we have multiple entries with Index " + slot);
                continue;
            }
            this.getTopInventory().setItem(slot, item);
            this.buttons.put(trait, item);
        }
        this.getTopInventory().setItem(8, this.generateFreeItem(freePoints, level));
        if (this.somethingChanged) {
            this.getTopInventory().setItem(53, this.applyItem);
        }
        this.getTopInventory().setItem(52, this.discardItem);
    }

    private List<String> skillTrees() {
        HashSet<String> trees = new HashSet<String>();
        Set<Trait> traits = TraitHolderCombinder.getAllTraitsOfPlayer(this.racPlayer);
        for (Trait trait : traits) {
            trees.add(trait.getSkillTreeName());
        }
        return new ArrayList<String>(trees);
    }

    private ItemStack generateItemForTrait(Trait trait, Map<Trait, Integer> traitsHasWithLevels, int playerLevel, int freePoints) {
        boolean canUse;
        int maxSkillLevel = trait.getSkillMaxLevel();
        int playerSkillLevel = traitsHasWithLevels.containsKey(trait) ? traitsHasWithLevels.get(trait) : 0;
        boolean playerHasMaxLevel = playerSkillLevel >= maxSkillLevel;
        int traitLevelNeeded = trait.getSkillMinLevel(playerSkillLevel + 1);
        boolean playerHasLevel = playerLevel >= traitLevelNeeded;
        String excluded = this.getForExcusions(trait, traitsHasWithLevels);
        boolean isExcluded = !excluded.isEmpty();
        boolean hasPoints = freePoints >= trait.getSkillPointCost(playerSkillLevel + 1);
        boolean hasPrequisits = this.hasPrequisits(trait, traitsHasWithLevels);
        boolean bl = canUse = hasPoints && hasPrequisits && playerHasLevel && !isExcluded;
        ChatColor titleColor = playerHasMaxLevel ? ChatColor.BLUE : (canUse ? ChatColor.GREEN : ChatColor.DARK_RED);
        String title = titleColor + trait.getDisplayName() + " (" + playerSkillLevel + "/" + maxSkillLevel + ")";
        String levelString = (playerHasLevel ? ChatColor.GREEN : ChatColor.RED) + "Needs level: " + traitLevelNeeded;
        String pointsString = (hasPoints ? ChatColor.GREEN : ChatColor.RED) + "Needs: " + trait.getSkillPointCost(playerSkillLevel + 1) + " Points";
        String prequisitString = trait.getSkillTreePrequisits(playerSkillLevel + 1).isEmpty() ? "" : ChatColor.YELLOW + "Prequisits: " + this.generatePrequisitString(trait, traitsHasWithLevels);
        LinkedList<String> lore = new LinkedList<String>();
        lore.addAll(Arrays.asList(trait.getPrettyConfiguration().split(Pattern.quote("#n"))));
        lore.add("");
        if (playerHasMaxLevel) {
            lore.add(ChatColor.AQUA + "Already learned");
        } else {
            lore.add(pointsString);
            lore.add(levelString);
            if (!prequisitString.isEmpty()) {
                lore.add(prequisitString);
            }
            if (isExcluded) {
                lore.add(ChatColor.DARK_RED + "Excluded by: " + ChatColor.RED + excluded);
            }
        }
        ItemStack item = trait.getSkillTreeSymbol();
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(title);
        meta.setLore(lore);
        if (playerHasMaxLevel) {
            meta.addEnchant(Enchantment.DURABILITY, 1, true);
            if (VollotileCodeManager.getVollotileCode().getVersion().isVersionGreaterOrEqual(VollotileCode.MCVersion.v1_8_R3)) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
        }
        if (VollotileCodeManager.getVollotileCode().getVersion().isVersionGreaterOrEqual(VollotileCode.MCVersion.v1_8_R3)) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        }
        item.setItemMeta(meta);
        ItemUtils.setUnbreakable(item, true);
        return item;
    }

    private String getForExcusions(Trait trait, Map<Trait, Integer> traitsHasWithLevels) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Trait, Integer> entry : traitsHasWithLevels.entrySet()) {
            if (entry.getValue() <= 0 || !entry.getKey().getExcludesOtherTraits().contains(trait)) continue;
            if (builder.length() != 0) {
                builder.append(", ");
            }
            builder.append(entry.getKey().getDisplayName());
        }
        return builder.toString();
    }

    private String generatePrequisitString(Trait trait, Map<Trait, Integer> traitsHas) {
        int playerSkillLevel = traitsHas.containsKey(trait) ? traitsHas.get(trait) : 0;
        StringBuilder builder = new StringBuilder();
        Iterator<String> iterator = trait.getSkillTreePrequisits(playerSkillLevel + 1).iterator();
        while (iterator.hasNext()) {
            String pre = iterator.next();
            String[] split = pre.split(Pattern.quote("@"));
            String preName = split[0];
            int level = split.length == 1 ? 1 : StringFormatUtils.parseInt(split[1], 1);
            Trait found = null;
            for (Trait has : traitsHas.keySet()) {
                if (!has.getDisplayName().equalsIgnoreCase(preName)) continue;
                found = has;
                break;
            }
            boolean has = found != null && traitsHas.get(found) >= level;
            builder.append(has ? ChatColor.GREEN : ChatColor.RED);
            builder.append(has ? found.getDisplayName() : preName).append(" ").append(level);
            if (!iterator.hasNext()) continue;
            builder.append(ChatColor.WHITE).append(", ");
        }
        return builder.toString();
    }

    private boolean hasPrequisits(Trait trait, Map<Trait, Integer> traitsHas) {
        int playerSkillLevel = traitsHas.containsKey(trait) ? traitsHas.get(trait) : 0;
        for (String pre : trait.getSkillTreePrequisits(playerSkillLevel + 1)) {
            String[] preSplit = pre.split(Pattern.quote("@"));
            String preName = preSplit[0];
            int level = preSplit.length == 1 ? 1 : StringFormatUtils.parseInt(preSplit[1], 1);
            boolean found = false;
            for (Map.Entry<Trait, Integer> has : traitsHas.entrySet()) {
                if (!has.getKey().getDisplayName().equalsIgnoreCase(preName) || has.getValue() < level) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private ItemStack generateFreeItem(int freePoints, int level) {
        ItemStack item = new ItemStack(Material.CAKE, Math2.clamp(1, freePoints, 64));
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(ChatColor.AQUA + "Info - Read lore");
        meta.setLore(Arrays.asList(ChatColor.YELLOW + "Free Skillpoints: " + ChatColor.AQUA + freePoints, ChatColor.YELLOW + "Level: " + ChatColor.AQUA + level));
        item.setItemMeta(meta);
        return item;
    }

    private Collection<Trait> filterForExclusions(Collection<Trait> toFilter) {
        HashSet<Trait> filtered = new HashSet<Trait>(toFilter);
        for (Trait contained : toFilter) {
            boolean hasSkilled;
            boolean bl = hasSkilled = this.racPlayer.getSkillTreeManager().getLevel(contained) > 0;
            if (!hasSkilled) continue;
            filtered.removeAll(contained.getExcludesOtherTraits());
        }
        return filtered;
    }

    private Collection<Trait> getPermanent(Collection<Trait> traits) {
        HashSet<Trait> permanent = new HashSet<Trait>();
        if (traits == null || traits.isEmpty()) {
            return permanent;
        }
        for (Trait trait : traits) {
            if (!trait.isPermanentSkill()) continue;
            permanent.add(trait);
        }
        return permanent;
    }

    @Override
    protected boolean onBackPressed() {
        return true;
    }

    @Override
    protected void onAcceptPressed() {
    }

    @Override
    protected void onSelectionItemPressed(int slot, ItemStack item) {
        int neededLevel;
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        if (this.applyItem.isSimilar(item)) {
            this.applyCurrentSettings();
            return;
        }
        if (this.discardItem.isSimilar(item)) {
            this.discardCurrentSettings();
            return;
        }
        Trait trait = this.getTraitForItem(item);
        if (trait == null) {
            return;
        }
        int playerTraitLevel = this.toApply.containsKey(trait) ? this.toApply.get(trait) : 0;
        int freePoints = this.racPlayer.getSkillTreeManager().getFreeSkillpoints() - this.tempFreePointsToRemove;
        int level = LevelAPI.getCurrentLevel(this.racPlayer);
        if (playerTraitLevel >= trait.getSkillMaxLevel()) {
            this.player.sendMessage(ChatColor.RED + "You alreadsy have this Trait at max level.");
            return;
        }
        if (freePoints < trait.getSkillPointCost(playerTraitLevel + 1)) {
            this.player.sendMessage(ChatColor.RED + "You do not have enough free Skill-Points.");
            return;
        }
        if (!this.hasPrequisits(trait, this.toApply)) {
            this.player.sendMessage(ChatColor.RED + "You do not have all prequisits!");
            return;
        }
        int n = neededLevel = trait instanceof TraitWithRestrictions ? ((TraitWithRestrictions)trait).getMinLevel() : 0;
        if (level < neededLevel) {
            this.player.sendMessage(ChatColor.RED + "Your level is too low!");
            return;
        }
        this.toApply.put(trait, playerTraitLevel + 1);
        this.tempFreePointsToRemove += trait.getSkillPointCost(playerTraitLevel + 1);
        this.somethingChanged = true;
        this.redraw();
    }

    private void discardCurrentSettings() {
        this.toApply.clear();
        this.toApply.putAll(this.racPlayer.getSkillTreeManager().getTraitsWithLevels());
        this.tempFreePointsToRemove = 0;
        this.somethingChanged = false;
        this.redraw();
    }

    private void applyCurrentSettings() {
        this.close();
        PlayerSkillTreeManager manager = this.racPlayer.getSkillTreeManager();
        manager.replaceWithNew(this.toApply);
        this.racPlayer.getArrowManager().rescanPlayer();
        this.racPlayer.getSpellManager().rescan();
        this.somethingChanged = false;
        this.player.sendMessage(ChatColor.GREEN + "Changes applied.");
    }

    private Trait getTraitForItem(ItemStack item) {
        for (Map.Entry<Trait, ItemStack> entry : this.buttons.entrySet()) {
            if (!item.isSimilar(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }
}

