/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.gui;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.APIs.LevelAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractHolderManager;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.classes.ClassContainer;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race.RaceContainer;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.HolderPreSelectEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.classevent.PreClassSelectEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.raceevent.PreRaceSelectEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.util.RaC.formating.StringFormatUtils;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class HolderInventory
extends InventoryView {
    protected int numberOfHolder;
    private final Player player;
    private final Inventory holderInventory;
    private final AbstractHolderManager holderManager;
    private static final RacesAndClasses plugin = RacesAndClasses.getPlugin();
    private final DecimalFormat format = new DecimalFormat("0.0");

    public HolderInventory(Player player, AbstractHolderManager holderManager) {
        String name;
        this.player = player;
        this.holderManager = holderManager;
        this.numberOfHolder = 0;
        int inventorySize = (int)(Math.ceil((double)holderManager.getAllHolderNames().size() / 9.0) + 1.0) * 9;
        if (inventorySize < 35) {
            inventorySize = 36;
        }
        if ((name = LanguageAPI.translate(RaCPlayerManager.get().getPlayer(player), "holder_selectiongui_header", "holder", StringFormatUtils.firstCapitalRestLow(holderManager.getContainerTypeAsString()), "player", player.getName())).length() > 32) {
            name = name.substring(0, 32);
        }
        this.holderInventory = Bukkit.getServer().createInventory((InventoryHolder)player, inventorySize, name);
        this.fillWithHolders();
    }

    private void fillWithHolders() {
        ItemStack item;
        this.getTopInventory().clear();
        HashMap<ItemStack, Integer> slotsToFill = new HashMap<ItemStack, Integer>();
        for (String holderName : this.holderManager.listAllVisibleHolders()) {
            if (HolderInventory.plugin.testingMode) {
                ++this.numberOfHolder;
                continue;
            }
            AbstractTraitHolder holder = this.holderManager.getHolderByName(holderName);
            if (!this.hasPermission(holder, this.holderManager)) continue;
            item = this.generateForHolder(holder);
            slotsToFill.put(item, holder.getGuiSlot());
            ++this.numberOfHolder;
        }
        HashSet<ItemStack> toAddAfter = new HashSet<ItemStack>();
        for (Map.Entry entry : slotsToFill.entrySet()) {
            item = (ItemStack)entry.getKey();
            int slot = (Integer)entry.getValue();
            if (slot < 0 || slot > this.getTopInventory().getSize()) {
                toAddAfter.add(item);
                continue;
            }
            this.getTopInventory().setItem(slot, item);
        }
        for (ItemStack item2 : toAddAfter) {
            this.getTopInventory().addItem(new ItemStack[]{item2});
        }
    }

    private ItemStack generateForHolder(AbstractTraitHolder holder) {
        List lore;
        ItemStack item = holder.getHolderSelectionItem() != null ? holder.getHolderSelectionItem().clone() : new ItemStack(Material.BOOK_AND_QUILL);
        ItemMeta meta = item.getItemMeta();
        boolean isEmptyTag = holder.getTag() == null || holder.getTag().equals("");
        meta.setDisplayName(String.valueOf(holder.getDisplayName()) + " " + (isEmptyTag ? "[" + holder.getDisplayName() + "]" : holder.getTag()));
        List list = lore = meta.hasLore() ? meta.getLore() : new LinkedList();
        if (holder.hasHolderDescription()) {
            String[] split;
            String description = holder.getHolderDescription();
            String[] stringArray = split = description.split("#n");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String desc = stringArray[n2];
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)desc));
                ++n2;
            }
        }
        if (!holder.isHideConfigInGui()) {
            String manaString;
            String healthString = this.getHealthString(holder);
            if (healthString != null) {
                lore.add(ChatColor.AQUA + LanguageAPI.translate(RaCPlayerManager.get().getPlayer(this.player), "health", new String[0]) + ": ");
                lore.add(ChatColor.LIGHT_PURPLE + "  " + healthString);
            }
            if ((manaString = this.getManaString(holder)) != null) {
                lore.add(ChatColor.AQUA + LanguageAPI.translate(RaCPlayerManager.get().getPlayer(this.player), "mana", new String[0]) + ": ");
                lore.add(ChatColor.LIGHT_PURPLE + "  " + manaString);
            }
            lore.add(ChatColor.AQUA + LanguageAPI.translate(RaCPlayerManager.get().getPlayer(this.player), "armor", new String[0]) + ":");
            if (holder.getArmorPerms().size() > 0) {
                lore.add(ChatColor.LIGHT_PURPLE + holder.getArmorString());
            } else {
                lore.add(ChatColor.LIGHT_PURPLE + "ANY");
            }
            lore.addAll(holder.getPreconditions().generateDescription(RaCPlayerManager.get().getPlayer(this.player)));
        }
        if (!holder.isHideTraitsInGui()) {
            lore.add(ChatColor.AQUA + LanguageAPI.translate(RaCPlayerManager.get().getPlayer(this.player), "traits", new String[0]) + ":");
            for (Trait trait : holder.getVisibleTraits()) {
                lore.add(ChatColor.DARK_AQUA + trait.getDisplayName() + ": ");
                String traitConfig = trait.getPrettyConfiguration();
                String[] words = traitConfig.split(" ");
                String currentLine = ChatColor.YELLOW + " -" + words[0];
                int i = 1;
                while (i < words.length) {
                    String currentWord = words[i];
                    if (currentLine.length() + words.length + 1 > 29) {
                        lore.add(currentLine);
                        currentLine = ChatColor.YELLOW + "  " + currentWord;
                    } else {
                        currentLine = String.valueOf(currentLine) + " " + currentWord;
                    }
                    ++i;
                }
                if (currentLine.length() <= 0) continue;
                lore.add(currentLine);
            }
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private String getHealthString(AbstractTraitHolder holder) {
        double max = holder.getMaxHealthMod(LevelAPI.getCurrentLevel(this.player));
        return String.valueOf(max >= 0.0 ? "+" : "") + this.format.format(max);
    }

    private String getManaString(AbstractTraitHolder holder) {
        double max = holder.getManaBonus(LevelAPI.getCurrentLevel(this.player));
        return max == 0.0 ? null : String.valueOf(max >= 0.0 ? "+" : "") + this.format.format(max);
    }

    private boolean hasPermission(AbstractTraitHolder holder, AbstractHolderManager manager) {
        HolderPreSelectEvent event = null;
        if (manager == plugin.getClassManager()) {
            event = new PreClassSelectEvent(this.player, (ClassContainer)holder, true, false);
        }
        if (manager == plugin.getRaceManager()) {
            event = new PreRaceSelectEvent(this.player, (RaceContainer)holder, true, false);
        }
        if (event == null) {
            return true;
        }
        plugin.getServer().getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public Inventory getTopInventory() {
        return this.holderInventory;
    }

    public Inventory getBottomInventory() {
        return this.player.getInventory();
    }

    public HumanEntity getPlayer() {
        return this.player;
    }

    public InventoryType getType() {
        return InventoryType.CHEST;
    }

    public int getNumberOfHolder() {
        return this.numberOfHolder;
    }

    public AbstractHolderManager getHolderManager() {
        return this.holderManager;
    }
}

