/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.classes;

import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractHolderManager;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.DefaultContainer;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.PlayerHolderAssociation;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.classes.ClassContainer;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.HolderSelectedEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.classevent.AfterClassChangedEvent;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.classevent.AfterClassSelectedEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.saving.PlayerSavingData;
import de.tobiyas.racesandclasses.util.consts.Consts;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;

public class ClassManager
extends AbstractHolderManager {
    public ClassManager() {
        super(Consts.classesYML, "classes");
    }

    @Override
    public void init() {
        DefaultContainer.createSTDClasses();
        super.init();
    }

    @Override
    protected AbstractTraitHolder generateTraitHolder(YAMLConfigExtended traitHolderConfig, String holderName) {
        return ClassContainer.loadClass(traitHolderConfig, holderName);
    }

    @Override
    protected String getConfigPrefix() {
        return "class";
    }

    @Override
    public AbstractTraitHolder getDefaultHolder() {
        String className = this.plugin.getConfigManager().getGeneralConfig().getConfig_takeClassWhenNoClass();
        if (className == null || className.isEmpty()) {
            return null;
        }
        AbstractTraitHolder container = this.getHolderByName(className);
        return container;
    }

    @Override
    protected void initDefaultHolder() {
    }

    @Override
    public String getContainerTypeAsString() {
        return "class";
    }

    @Override
    protected String getCorrectFieldFromDBHolder(PlayerHolderAssociation container) {
        return container.getClassName();
    }

    @Override
    protected void saveContainerToDBField(PlayerHolderAssociation container, String name) {
        container.setClassName(name);
    }

    @Override
    protected HolderSelectedEvent generateAfterSelectEvent(RaCPlayer player, AbstractTraitHolder newHolder) {
        return new AfterClassSelectedEvent(player.getPlayer(), (ClassContainer)newHolder);
    }

    @Override
    protected HolderSelectedEvent generateAfterChangeEvent(RaCPlayer player, AbstractTraitHolder newHolder, AbstractTraitHolder oldHolder) {
        return new AfterClassChangedEvent(player.getPlayer(), (ClassContainer)newHolder, (ClassContainer)oldHolder);
    }

    @Override
    protected AbstractTraitHolder getStartingHolder() {
        String className = this.plugin.getConfigManager().getGeneralConfig().getConfig_takeClassWhenNoClass();
        if (className == null || "".equals(className)) {
            return this.getDefaultHolder();
        }
        AbstractTraitHolder holder = this.getHolderByName(className);
        return holder != null ? holder : this.getDefaultHolder();
    }

    @Override
    protected AbstractTraitHolder getHolder(PlayerSavingData data) {
        return this.getHolderByName(data.getClassName());
    }

    @Override
    protected void saveToContainer(PlayerSavingData data, AbstractTraitHolder holder) {
        data.setClassName(holder.getDisplayName());
    }
}

