/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.datacontainer.traitholdercontainer;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.classes.ClassContainer;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race.RaceContainer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.skilltree.PlayerSkillTreeManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class TraitHolderCombinder {
    private static boolean useSkillSystem() {
        return RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().isConfig_useSkillSystem();
    }

    public static boolean checkContainer(RaCPlayer player, Trait trait) {
        return TraitHolderCombinder.checkContainer(player, trait, false);
    }

    public static boolean checkContainer(RaCPlayer player, Trait trait, boolean ignoreSkilling) {
        Set<AbstractTraitHolder> holder;
        if (!ignoreSkilling && TraitHolderCombinder.useSkillSystem()) {
            if (player.getSkillTreeManager().getLevel(trait) > 0) {
                return true;
            }
            if (!trait.isPermanentSkill()) {
                return false;
            }
        }
        if ((holder = trait.getTraitHolders()) == null || holder.isEmpty()) {
            return true;
        }
        RaceContainer raceHolder = player.getRace();
        if (holder.contains(raceHolder)) {
            return true;
        }
        ClassContainer classHolder = player.getclass();
        return holder.contains(classHolder);
    }

    public static Set<Trait> getAllTraitsOfPlayer(RaCPlayer player) {
        ClassContainer classContainer;
        HashSet<Trait> traits = new HashSet<Trait>();
        RaceContainer raceContainer = player.getRace();
        if (raceContainer != null) {
            traits.addAll(raceContainer.getTraits());
        }
        if ((classContainer = player.getclass()) != null) {
            traits.addAll(classContainer.getTraits());
        }
        return traits;
    }

    public static Set<Trait> getSkillTreeReducedTraitsOfPlayer(RaCPlayer player) {
        Set<Trait> traits = TraitHolderCombinder.getReducedTraitsOfPlayer(player);
        if (TraitHolderCombinder.useSkillSystem()) {
            PlayerSkillTreeManager skillTreeManager = player.getSkillTreeManager();
            Iterator<Trait> it = traits.iterator();
            while (it.hasNext()) {
                Trait check = it.next();
                if (check.isPermanentSkill() || skillTreeManager.getLevel(check) > 0) continue;
                it.remove();
            }
        }
        TraitHolderCombinder.filterForReplacementTraits(traits);
        return traits;
    }

    private static void filterForReplacementTraits(Collection<Trait> traits) {
        if (traits.isEmpty()) {
            return;
        }
        HashSet<String> toRemove = new HashSet<String>();
        for (Trait trait : traits) {
            toRemove.addAll(trait.getReplacesOtherTraits());
        }
        if (toRemove.isEmpty()) {
            return;
        }
        Iterator<Trait> traitIt = traits.iterator();
        while (traitIt.hasNext()) {
            Trait trait = traitIt.next();
            if (trait == null || !toRemove.contains(trait.getDisplayName())) continue;
            traitIt.remove();
        }
    }

    public static Set<Trait> getReducedTraitsOfPlayer(RaCPlayer offlinePlayer) {
        Set<Trait> traits = TraitHolderCombinder.getAllTraitsOfPlayer(offlinePlayer);
        traits = TraitHolderCombinder.filterForDoubles(traits);
        return traits;
    }

    private static Set<Trait> filterForDoubles(Set<Trait> traits) {
        HashSet<Trait> filtered = new HashSet<Trait>();
        for (Trait trait : traits) {
            if (trait.isStackable()) {
                filtered.add(trait);
                continue;
            }
            Trait doubled = TraitHolderCombinder.containsTrait(filtered, trait);
            if (doubled == null) {
                filtered.add(trait);
                continue;
            }
            filtered.remove(doubled);
            filtered.add(TraitHolderCombinder.selectBetter(doubled, trait));
        }
        return filtered;
    }

    private static Trait selectBetter(Trait trait1, Trait trait2) {
        if (trait1.isBetterThan(trait2)) {
            return trait1;
        }
        return trait2;
    }

    private static Trait containsTrait(Set<Trait> traits, Trait newTrait) {
        if (newTrait == null || traits == null) {
            return null;
        }
        for (Trait trait : traits) {
            if (trait == null || !TraitHolderCombinder.sameTrait(trait, newTrait)) continue;
            return trait;
        }
        return null;
    }

    private static boolean sameTrait(Trait trait1, Trait trait2) {
        return trait1.getName().equalsIgnoreCase(trait2.getName());
    }
}

