/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.datacontainer.traitholdercontainer;

import de.tobiyas.racesandclasses.APIs.LevelAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractHolderManager;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.classes.ClassManager;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race.RaceManager;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class HolderSelectionPreconditions {
    public static final HolderSelectionPreconditions EMPTY_RACE = new HolderSelectionPreconditions(-1, null, null, RacesAndClasses.getPlugin().getRaceManager());
    public static final HolderSelectionPreconditions EMPTY_CLASS = new HolderSelectionPreconditions(-1, null, null, RacesAndClasses.getPlugin().getClassManager());
    private final int minLevel;
    private final String preHolder;
    private final String prePerm;
    private final AbstractHolderManager holderManager;

    private HolderSelectionPreconditions(int minLevel, String preHolder, String prePerm, AbstractHolderManager holderManager) {
        this.minLevel = minLevel;
        this.preHolder = preHolder;
        this.prePerm = prePerm;
        this.holderManager = holderManager;
    }

    public HolderPreconditionResult checkPreconditions(RaCPlayer player) {
        AbstractTraitHolder holder;
        if (this.minLevel > 0 && player.getLevelManager().getCurrentLevel() < this.minLevel) {
            return HolderPreconditionResult.LEVEL_TOO_LOW;
        }
        if (this.preHolder != null && (holder = this.holderManager.getHolderOfPlayer(player)) != null && this.preHolder.equalsIgnoreCase(holder.getDisplayName())) {
            return HolderPreconditionResult.HOLDER_NOT_PRESENT;
        }
        if (this.prePerm != null && !RacesAndClasses.getPlugin().getPermissionManager().checkPermissionsSilent((CommandSender)player.getPlayer(), this.prePerm)) {
            return HolderPreconditionResult.PERMISSION_NOT_PRESENT;
        }
        return HolderPreconditionResult.RESTRICTIONS_MET;
    }

    public List<String> generateDescription(RaCPlayer player) {
        LinkedList<String> list = new LinkedList<String>();
        list.add(ChatColor.LIGHT_PURPLE + "Preconditions:");
        if (this.minLevel > 0) {
            boolean hasLevel = LevelAPI.getCurrentLevel(player) >= this.minLevel;
            list.add((hasLevel ? ChatColor.GREEN : ChatColor.RED) + "- Needs level " + this.minLevel);
        }
        if (this.preHolder != null) {
            AbstractTraitHolder holder = this.holderManager.getHolderOfPlayer(player);
            boolean hasHolder = holder != null && holder.getDisplayName().equalsIgnoreCase(this.preHolder);
            list.add((hasHolder ? ChatColor.GREEN : ChatColor.RED) + "- Needs " + holder.getContainerTypeAsString() + " " + this.preHolder);
        }
        if (this.prePerm != null) {
            boolean hasPerm = RacesAndClasses.getPlugin().getPermissionManager().checkPermissionsSilent((CommandSender)player.getRealPlayer(), this.prePerm);
            list.add((hasPerm ? ChatColor.GREEN : ChatColor.RED) + "- Needs Permission");
        }
        if (list.size() == 1) {
            list.clear();
        }
        return list;
    }

    public static HolderSelectionPreconditions parse(YAMLConfigExtended config, AbstractHolderManager manager) {
        if (config == null || !config.getValidLoad()) {
            return HolderSelectionPreconditions.getEmpty(manager);
        }
        if (config.getRootChildren().isEmpty()) {
            return HolderSelectionPreconditions.getEmpty(manager);
        }
        String pre = config.getRootChildren().iterator().next();
        pre = String.valueOf(pre) + ".preconditions.";
        int preLevel = config.getInt(String.valueOf(pre) + "level", -1);
        String holder = config.getString(String.valueOf(pre) + "holder", null);
        String permission = config.getString(String.valueOf(pre) + "permission", null);
        return new HolderSelectionPreconditions(preLevel, holder, permission, manager);
    }

    public static HolderSelectionPreconditions getEmpty(AbstractHolderManager manager) {
        if (manager instanceof RaceManager) {
            return EMPTY_RACE;
        }
        if (manager instanceof ClassManager) {
            return EMPTY_CLASS;
        }
        return EMPTY_RACE;
    }

    public static enum HolderPreconditionResult {
        LEVEL_TOO_LOW,
        HOLDER_NOT_PRESENT,
        PERMISSION_NOT_PRESENT,
        RESTRICTIONS_MET;

    }
}

