/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.datacontainer.traitholdercontainer;

import de.tobiyas.racesandclasses.RacesAndClasses;
import java.io.File;
import java.io.IOException;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;

public class DefaultContainer {
    public static void createSTDRaces() {
        RacesAndClasses plugin = RacesAndClasses.getPlugin();
        File raceDir = new File(plugin.getDataFolder(), "races");
        if (raceDir.exists()) {
            return;
        }
        raceDir.mkdirs();
        plugin.log("No Race file found. Creating new.");
        YamlConfiguration orcConfig = new YamlConfiguration();
        File orcFile = new File(raceDir, "orc.yml");
        orcConfig.createSection("Orc");
        orcConfig.createSection("Orc.config");
        orcConfig.createSection("Orc.traits");
        orcConfig.set("Orc.config.tag", (Object)"[Orc]");
        orcConfig.set("Orc.config.healthbonus", (Object)10);
        orcConfig.set("Orc.config.guislot", (Object)-1);
        orcConfig.set("Orc.config.armor", (Object)"iron,diamond,chain");
        orcConfig.createSection("Orc.traits.DamageReduceTrait");
        orcConfig.set("Orc.traits.DamageReduceTrait.operation", (Object)Character.valueOf('*'));
        orcConfig.set("Orc.traits.DamageReduceTrait.value", (Object)0.5);
        orcConfig.createSection("Orc.traits.BerserkerRageTrait");
        orcConfig.set("Orc.traits.BerserkerRageTrait.operation", (Object)Character.valueOf('+'));
        orcConfig.set("Orc.traits.BerserkerRageTrait.value", (Object)1);
        orcConfig.set("Orc.traits.BerserkerRageTrait.cooldown", (Object)30);
        YamlConfiguration elvesConfig = new YamlConfiguration();
        File elvesFile = new File(raceDir, "elves.yml");
        elvesConfig.createSection("Elv.config");
        elvesConfig.createSection("Elv.traits");
        elvesConfig.set("Elv.config.tag", (Object)"[Elv]");
        elvesConfig.set("Elv.config.healthbonus", (Object)0);
        elvesConfig.set("Elv.config.guislot", (Object)-1);
        elvesConfig.set("Elv.config.armor", (Object)"leather,gold,chain");
        elvesConfig.createSection("Elv.traits.FallResistanceTrait");
        elvesConfig.set("Elv.traits.FallResistanceTrait.operation", (Object)Character.valueOf('-'));
        elvesConfig.set("Elv.traits.FallResistanceTrait.value", (Object)2);
        elvesConfig.createSection("Elv.traits.SprintTrait");
        elvesConfig.set("Elv.traits.SprintTrait.duration", (Object)10);
        elvesConfig.set("Elv.traits.SprintTrait.value", (Object)3);
        elvesConfig.set("Elv.traits.SprintTrait.cooldown", (Object)60);
        try {
            orcConfig.save(orcFile);
            elvesConfig.save(elvesFile);
        }
        catch (IOException e) {
            plugin.log("Saving STD races.yml failed.");
            return;
        }
    }

    public static void createSTDClasses() {
        RacesAndClasses plugin = RacesAndClasses.getPlugin();
        File classDir = new File(plugin.getDataFolder(), "classes");
        if (classDir.exists()) {
            return;
        }
        classDir.mkdirs();
        plugin.log("No Class files found. Creating new.");
        YamlConfiguration warriorConfig = new YamlConfiguration();
        File warriorFile = new File(classDir, "warrior.yml");
        warriorConfig.createSection("warrior");
        warriorConfig.createSection("warrior.config");
        warriorConfig.createSection("warrior.traits");
        warriorConfig.set("warrior.config.tag", (Object)"[Warrior]");
        warriorConfig.set("warrior.config.healthbonus", (Object)5);
        warriorConfig.set("warrior.config.guislot", (Object)-1);
        warriorConfig.createSection("warrior.traits.SwordDamageIncreaseTrait");
        warriorConfig.set("warrior.traits.SwordDamageIncreaseTrait.operation", (Object)Character.valueOf('+'));
        warriorConfig.set("warrior.traits.SwordDamageIncreaseTrait.value", (Object)1);
        warriorConfig.createSection("warrior.traits.AxeDamageIncreaseTrait");
        warriorConfig.set("warrior.traits.AxeDamageIncreaseTrait.operation", (Object)Character.valueOf('+'));
        warriorConfig.set("warrior.traits.AxeDamageIncreaseTrait.value", (Object)1);
        YamlConfiguration archerConfig = new YamlConfiguration();
        File archerFile = new File(classDir, "archer.yml");
        archerConfig.createSection("archer");
        archerConfig.createSection("archer.config");
        archerConfig.createSection("archer.traits");
        archerConfig.set("archer.config.tag", (Object)"[Archer]");
        archerConfig.set("archer.config.healthbonus", (Object)"+1");
        archerConfig.set("archer.config.guislot", (Object)-1);
        archerConfig.createSection("archer.traits.PoisonArrowTrait");
        archerConfig.set("archer.traits.PoisonArrowTrait.duration", (Object)10);
        archerConfig.set("archer.traits.PoisonArrowTrait.totalDamage", (Object)10);
        archerConfig.set("archer.traits.PoisonArrowTrait.cooldown", (Object)30);
        archerConfig.createSection("archer.traits.FireArrowTrait");
        archerConfig.set("archer.traits.FireArrowTrait.duration", (Object)10);
        archerConfig.set("archer.traits.FireArrowTrait.totalDamage", (Object)10);
        archerConfig.set("archer.traits.FireArrowTrait.cooldown", (Object)30);
        archerConfig.createSection("archer.traits.TeleportArrowTrait");
        archerConfig.set("archer.traits.TeleportArrowTrait.cooldown", (Object)60);
        YamlConfiguration magicianConfig = new YamlConfiguration();
        File magicianFile = new File(classDir, "magician.yml");
        magicianConfig.createSection("magician");
        magicianConfig.createSection("magician.config");
        magicianConfig.createSection("magician.traits");
        magicianConfig.set("magician.config.tag", (Object)"[Magician]");
        magicianConfig.set("magician.config.healthbonus", (Object)-1);
        magicianConfig.set("magician.config.manabonus", (Object)20);
        magicianConfig.set("magician.config.guislot", (Object)-1);
        magicianConfig.createSection("magician.traits.ManaRegenerationTrait");
        magicianConfig.set("magician.traits.ManaRegenerationTrait.time", (Object)10);
        magicianConfig.set("magician.traits.ManaRegenerationTrait.value", (Object)2);
        magicianConfig.createSection("magician.traits.FireballTrait");
        magicianConfig.set("magician.traits.FireballTrait.cost", (Object)6);
        magicianConfig.set("magician.traits.FireballTrait.cooldown", (Object)10);
        magicianConfig.createSection("magician.traits.ItemForManaConsumeTrait");
        magicianConfig.set("magician.traits.ItemForManaConsumeTrait.cooldown", (Object)10);
        magicianConfig.set("magician.traits.ItemForManaConsumeTrait.item", (Object)"WHEAT");
        magicianConfig.set("magician.traits.ItemForManaConsumeTrait.cost", (Object)1);
        magicianConfig.set("magician.traits.ItemForManaConsumeTrait.value", (Object)10);
        magicianConfig.createSection("magician.traits.WallTrait");
        magicianConfig.set("magician.traits.WallTrait.cooldown", (Object)10);
        magicianConfig.set("magician.traits.WallTrait.cost", (Object)5);
        magicianConfig.set("magician.traits.WallTrait.duration", (Object)5);
        magicianConfig.createSection("magician.traits.ExplosionTrait");
        magicianConfig.set("magician.traits.ExplosionTrait.cooldown", (Object)10);
        magicianConfig.set("magician.traits.ExplosionTrait.cost", (Object)10);
        magicianConfig.set("magician.traits.ExplosionTrait.range", (Object)5);
        magicianConfig.set("magician.traits.ExplosionTrait.damage", (Object)4);
        magicianConfig.createSection("magician.traits.SlowFallTrait");
        magicianConfig.set("magician.traits.SlowFallTrait.cooldown", (Object)10);
        magicianConfig.set("magician.traits.SlowFallTrait.cost", (Object)5);
        magicianConfig.set("magician.traits.SlowFallTrait.duration", (Object)10);
        magicianConfig.createSection("magician.traits.ColdFeetTrait");
        magicianConfig.set("magician.traits.ColdFeetTrait.cost", (Object)5);
        magicianConfig.set("magician.traits.ColdFeetTrait.duration", (Object)10);
        YamlConfiguration shamanConfig = new YamlConfiguration();
        File shamanFile = new File(classDir, "shaman.yml");
        shamanConfig.createSection("shaman");
        shamanConfig.createSection("shaman.config");
        shamanConfig.createSection("shaman.traits");
        shamanConfig.set("shaman.config.tag", (Object)"[Shaman]");
        shamanConfig.set("shaman.config.healthbonus", (Object)1);
        shamanConfig.set("shaman.config.manabonus", (Object)20);
        shamanConfig.set("shaman.config.guislot", (Object)-1);
        shamanConfig.createSection("shaman.traits.HealTotemTrait");
        shamanConfig.set("shaman.traits.HealTotemTrait.duration", (Object)10);
        shamanConfig.set("shaman.traits.HealTotemTrait.value", (Object)3);
        shamanConfig.set("shaman.traits.HealTotemTrait.every", (Object)2);
        shamanConfig.createSection("shaman.traits.PotionTotemTrait");
        shamanConfig.set("shaman.traits.PotionTotemTrait.effect", (Object)6);
        shamanConfig.set("shaman.traits.PotionTotemTrait.duration", (Object)10);
        shamanConfig.createSection("shaman.traits.ItemForManaConsumeTrait");
        shamanConfig.set("shaman.traits.ItemForManaConsumeTrait.cooldown", (Object)10);
        shamanConfig.set("shaman.traits.ItemForManaConsumeTrait.item", (Object)Material.POTION.name());
        shamanConfig.set("shaman.traits.ItemForManaConsumeTrait.cost", (Object)1);
        shamanConfig.set("shaman.traits.ItemForManaConsumeTrait.value", (Object)10);
        shamanConfig.createSection("shaman.traits.ManaRegenerationTrait");
        shamanConfig.set("shaman.traits.ManaRegenerationTrait.value", (Object)1);
        shamanConfig.set("shaman.traits.ManaRegenerationTrait.time", (Object)5);
        try {
            shamanConfig.save(shamanFile);
            archerConfig.save(archerFile);
            magicianConfig.save(magicianFile);
            warriorConfig.save(warriorFile);
        }
        catch (IOException e) {
            plugin.log("Saving STD classes.yml failed.");
            return;
        }
    }
}

