/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.datacontainer.traitholdercontainer;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractHolderManager;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.HolderSelectionPreconditions;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.exceptions.HolderConfigParseException;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.exceptions.HolderParsingException;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.exceptions.HolderTraitParseException;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.permissionsettings.HolderPermissions;
import de.tobiyas.racesandclasses.playermanagement.leveling.values.LevelValueModifyReader;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.TraitStore;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.util.items.ItemUtils;
import de.tobiyas.racesandclasses.util.items.WandItem;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigParser;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.util.RaC.collections.ListCreateUtils;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import de.tobiyas.util.RaC.items.ItemUtils;
import de.tobiyas.util.RaC.vollotile.VollotileCode;
import de.tobiyas.util.RaC.vollotile.VollotileCodeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class AbstractTraitHolder {
    protected final YAMLConfigExtended config;
    protected final String configNodeName;
    protected String displayName;
    protected String holderTag;
    protected final Set<ItemUtils.ItemQuality> armorUsage;
    protected ItemStack holderSelectionItem;
    protected Set<Trait> traits;
    protected final HolderPermissions holderPermissions;
    protected LevelValueModifyReader.LevelModifier manaBonus;
    protected LevelValueModifyReader.LevelModifier healthBonus;
    protected final List<HolderTraitParseException> parsingExceptionsHappened;
    protected final Set<WandItem> additionalWandItems;
    protected String holderDescription = null;
    protected HolderSelectionPreconditions preconditions = null;
    protected int guiSlot = -1;
    protected boolean hideTraitsInGui = false;
    protected boolean hideConfigInGui = false;
    protected final Set<AbstractTraitHolder> parents = new HashSet<AbstractTraitHolder>();
    protected final Collection<String> commandExecuteOnJoin = new ArrayList<String>();
    protected final Collection<String> commandExecuteOnExit = new ArrayList<String>();

    protected AbstractTraitHolder(YAMLConfigExtended config, String name) {
        this.config = config;
        this.configNodeName = name;
        this.displayName = name;
        this.parsingExceptionsHappened = new LinkedList<HolderTraitParseException>();
        this.armorUsage = new HashSet<ItemUtils.ItemQuality>();
        this.traits = new HashSet<Trait>();
        this.holderTag = "[" + name + "]";
        this.additionalWandItems = new HashSet<WandItem>();
        this.holderSelectionItem = new ItemStack(Material.BOOK_AND_QUILL);
        this.preconditions = HolderSelectionPreconditions.getEmpty(this.getHolderManager());
        this.holderPermissions = new HolderPermissions(String.valueOf(this.getContainerTypeAsString()) + "-" + this.configNodeName);
        this.manaBonus = LevelValueModifyReader.LevelModifier.empty();
        this.healthBonus = LevelValueModifyReader.LevelModifier.empty();
        try {
            this.displayName = config.getString(String.valueOf(this.configNodeName) + ".config.name", this.configNodeName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public AbstractTraitHolder load() throws HolderParsingException {
        this.readConfigSection();
        this.readArmor();
        this.readTraitSection();
        this.readPermissionSection();
        this.readAdditionalWandMaterial();
        this.readHolderSelectionItem();
        this.readHolderDescription();
        this.readHolderPreconditions();
        return this;
    }

    public void readParents() {
        List<String> parentsName = this.config.getStringList(String.valueOf(this.configNodeName) + ".config.parents");
        List<String> ignoreParentTraits = this.config.getStringList(String.valueOf(this.configNodeName) + ".config.ignoreParentTraits");
        ListCreateUtils.toLowerCase(ignoreParentTraits);
        this.parents.clear();
        if (parentsName.isEmpty()) {
            return;
        }
        for (String name : parentsName) {
            AbstractTraitHolder parent = this.getHolderManager().getHolderByName(name);
            if (parent == null) continue;
            if (this.hasParentCyle(parent, 0, 50)) {
                RacesAndClasses.getPlugin().logError("The " + this.getContainerTypeAsString() + " has a cyclic Parent!" + " Please remove " + name + " in some sort from the cycle!");
                continue;
            }
            this.parents.add(parent);
            this.addHolderToAddParents(this, parent, 0, 50, ignoreParentTraits);
        }
    }

    protected void readHolderPreconditions() {
        this.preconditions = HolderSelectionPreconditions.parse(this.config, this.getHolderManager());
    }

    protected boolean hasParentCyle(AbstractTraitHolder holder, int step, int border) {
        if (step > border) {
            return false;
        }
        if (holder.getParents().contains(this)) {
            return true;
        }
        for (AbstractTraitHolder parent : holder.getParents()) {
            if (!this.hasParentCyle(parent, step + 1, border)) continue;
            return true;
        }
        return false;
    }

    protected void addHolderToAddParents(AbstractTraitHolder origin, AbstractTraitHolder holder, int step, int border, List<String> toIgnore) {
        if (step > border) {
            return;
        }
        for (Trait trait : holder.getTraits()) {
            if (toIgnore.contains(String.valueOf(holder.getDisplayName().toLowerCase()) + "." + trait.getDisplayName().toLowerCase())) continue;
            origin.traits.add(trait);
            trait.addTraitHolder(origin);
        }
        for (AbstractTraitHolder parent : holder.getParents()) {
            parent.addHolderToAddParents(origin, parent, step + 1, border, toIgnore);
        }
    }

    protected void readHolderDescription() {
        String toSet = this.config.getString(String.valueOf(this.configNodeName) + ".description", null);
        if (toSet != null) {
            this.holderDescription = toSet;
        }
    }

    protected void readHolderSelectionItem() {
        Material mat = Material.BOOK_AND_QUILL;
        try {
            mat = Material.getMaterial((int)this.config.getInt(String.valueOf(this.configNodeName) + ".gui.item.id", Material.BOOK_AND_QUILL.getId()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        short damageValue = (short)this.config.getInt(String.valueOf(this.configNodeName) + ".gui.item.damage", 0);
        this.holderSelectionItem = new ItemStack(mat, 1, damageValue);
        ItemMeta meta = this.holderSelectionItem.getItemMeta();
        if (VollotileCodeManager.getVollotileCode().getVersion().isVersionGreaterOrEqual(VollotileCode.MCVersion.v1_8_R3)) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        }
        this.holderSelectionItem.setItemMeta(meta);
        ItemUtils.setUnbreakable(this.holderSelectionItem, true);
    }

    protected void readAdditionalWandMaterial() {
        this.additionalWandItems.clear();
        if (!this.config.contains(String.valueOf(this.configNodeName) + ".config.wandMaterial")) {
            return;
        }
        List<String> wandMatList = this.config.getStringList(String.valueOf(this.configNodeName) + ".config.wandMaterial");
        for (String line : wandMatList) {
            WandItem item = WandItem.generateFrom(line);
            if (item == null) continue;
            this.additionalWandItems.add(item);
        }
    }

    protected void readConfigSection() throws HolderConfigParseException {
        try {
            this.displayName = this.config.getString(String.valueOf(this.configNodeName) + ".config.name", this.configNodeName);
            this.manaBonus = new LevelValueModifyReader(this.config, String.valueOf(this.configNodeName) + ".config.manabonus").parse(0.0);
            this.healthBonus = new LevelValueModifyReader(this.config, String.valueOf(this.configNodeName) + ".config.healthbonus").parse(0.0);
            this.holderTag = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString(String.valueOf(this.configNodeName) + ".config.tag", "[" + this.configNodeName + "]"));
            this.guiSlot = this.config.getInt(String.valueOf(this.configNodeName) + ".config.guislot", -1);
            this.hideConfigInGui = this.config.getBoolean(String.valueOf(this.configNodeName) + ".config.hideConfigInGui", false);
            this.hideTraitsInGui = this.config.getBoolean(String.valueOf(this.configNodeName) + ".config.hideTraitsInGui", false);
            this.commandExecuteOnJoin.clear();
            this.commandExecuteOnExit.clear();
            this.commandExecuteOnJoin.addAll(this.config.getStringList(String.valueOf(this.configNodeName) + ".config.joinCommands"));
            this.commandExecuteOnJoin.addAll(this.config.getStringList(String.valueOf(this.configNodeName) + ".config.exitCommands"));
        }
        catch (Exception exp) {
            throw new HolderConfigParseException();
        }
    }

    protected void readArmor() {
        this.armorUsage.clear();
        String armorString = this.config.getString(String.valueOf(this.configNodeName) + ".config.armor", "").toLowerCase();
        this.armorUsage.addAll(ItemUtils.ItemQuality.parse(armorString));
    }

    protected void readTraitSection() {
        this.traits = new HashSet<Trait>();
        this.addSTDTraits();
        if (!this.config.isConfigurationSection(String.valueOf(this.configNodeName) + ".traits")) {
            return;
        }
        Set traitNames = this.config.getConfigurationSection(String.valueOf(this.configNodeName) + ".traits").getKeys(false);
        if (traitNames == null || traitNames.size() == 0) {
            return;
        }
        LinkedList<HolderTraitParseException> exceptionList = new LinkedList<HolderTraitParseException>();
        Iterator iterator = traitNames.iterator();
        while (iterator.hasNext()) {
            String traitName;
            String realTraitName = traitName = (String)iterator.next();
            if (traitName.contains("#")) {
                realTraitName = traitName.split("#")[0];
            }
            if (this.config.isString(String.valueOf(this.configNodeName) + ".traits." + traitName + ".trait")) {
                realTraitName = this.config.getString(String.valueOf(this.configNodeName) + ".traits." + traitName + ".trait");
            }
            try {
                Trait trait = TraitStore.buildTraitByName(realTraitName, this);
                if (trait == null) continue;
                String configPath = String.valueOf(this.configNodeName) + ".traits." + traitName;
                TraitConfigParser.configureTraitFromYAML(this.config, configPath, trait);
                trait.generalInit();
                if (trait instanceof Listener) {
                    RacesAndClasses.getPlugin().registerEvents((Listener)trait);
                }
                this.traits.add(trait);
            }
            catch (TraitConfigurationFailedException exp) {
                exceptionList.add(new HolderTraitParseException(exp.getMessage(), this));
                RacesAndClasses.getPlugin().log("Error on parsing: '" + this.getDisplayName() + "' Problem was: '" + exp.getMessage() + "' On Trait: '" + realTraitName + "'.");
            }
        }
        this.parsingExceptionsHappened.addAll(exceptionList);
    }

    protected void readPermissionSection() {
        this.holderPermissions.clear();
        if (!this.config.isList(String.valueOf(this.configNodeName) + ".permissions")) {
            return;
        }
        List<String> permissionList = this.config.getStringList(String.valueOf(this.configNodeName) + ".permissions");
        this.holderPermissions.add(permissionList);
    }

    protected abstract void addSTDTraits();

    public abstract boolean containsPlayer(RaCPlayer var1);

    public HolderPermissions getPermissions() {
        return this.holderPermissions;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getConfigNodeName() {
        return this.configNodeName;
    }

    public String getTag() {
        return this.holderTag;
    }

    public Set<Trait> getTraits() {
        return this.traits;
    }

    public int getGuiSlot() {
        return this.guiSlot;
    }

    public boolean isHideTraitsInGui() {
        return this.hideTraitsInGui;
    }

    public boolean isHideConfigInGui() {
        return this.hideConfigInGui;
    }

    public HolderPermissions getHolderPermissions() {
        return this.holderPermissions;
    }

    public HolderSelectionPreconditions getPreconditions() {
        return this.preconditions;
    }

    public Set<Trait> getVisibleTraits() {
        HashSet<Trait> traitSet = new HashSet<Trait>();
        for (Trait trait : this.getTraits()) {
            if (!trait.isVisible()) continue;
            traitSet.add(trait);
        }
        return traitSet;
    }

    public String getArmorString() {
        Set<ItemUtils.ItemQuality> qualities = this.getArmorPerms();
        String armorString = "";
        for (ItemUtils.ItemQuality quality : qualities) {
            armorString = String.valueOf(armorString) + quality.getName() + " ";
        }
        return armorString;
    }

    public Set<ItemUtils.ItemQuality> getArmorPerms() {
        return new HashSet<ItemUtils.ItemQuality>(this.armorUsage);
    }

    public String toString() {
        return this.displayName;
    }

    protected abstract String getContainerTypeAsString();

    public List<HolderTraitParseException> getParsingExceptionsHappened() {
        return this.parsingExceptionsHappened;
    }

    public double getManaBonus(int level) {
        return this.manaBonus.getForLevel(level);
    }

    public double getMaxHealthMod(int level) {
        return this.healthBonus.getForLevel(level);
    }

    public abstract AbstractHolderManager getHolderManager();

    public Set<WandItem> getAdditionalWandMaterials() {
        return new HashSet<WandItem>(this.additionalWandItems);
    }

    public ItemStack getHolderSelectionItem() {
        return this.holderSelectionItem;
    }

    public String getHolderDescription() {
        return this.holderDescription;
    }

    public boolean hasHolderDescription() {
        return this.holderDescription != null;
    }

    public Set<AbstractTraitHolder> getParents() {
        return new HashSet<AbstractTraitHolder>(this.parents);
    }

    public Collection<String> getCommandExecuteOnJoin() {
        return this.commandExecuteOnJoin;
    }

    public Collection<String> getCommandExecuteOnExit() {
        return this.commandExecuteOnExit;
    }
}

