/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.datacontainer.traitholdercontainer;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.PlayerHolderAssociation;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.exceptions.HolderConfigParseException;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.exceptions.HolderParsingException;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.exceptions.HolderTraitParseException;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.permissionsettings.PermissionRegisterer;
import de.tobiyas.racesandclasses.eventprocessing.events.holderevent.HolderSelectedEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.saving.PlayerSavingData;
import de.tobiyas.racesandclasses.saving.PlayerSavingManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import de.tobiyas.util.RaC.file.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public abstract class AbstractHolderManager {
    protected Map<RaCPlayer, AbstractTraitHolder> memberList;
    protected Set<AbstractTraitHolder> traitHolderList;
    protected final File oldFile;
    protected final File folder;
    protected final RacesAndClasses plugin = RacesAndClasses.getPlugin();

    public AbstractHolderManager(String traitHolderConfigPath, String folderName) {
        this.folder = new File(RacesAndClasses.getPlugin().getDataFolder(), folderName);
        this.oldFile = new File(traitHolderConfigPath);
        this.memberList = new HashMap<RaCPlayer, AbstractTraitHolder>();
        this.traitHolderList = new HashSet<AbstractTraitHolder>();
    }

    public void init() {
        this.clearOldTraitholders();
        this.readTraitHolderList();
        this.initDefaultHolder();
        this.setupPermissions();
    }

    private void clearOldTraitholders() {
        HashSet<Trait> toDeinit = new HashSet<Trait>();
        for (AbstractTraitHolder holder : this.traitHolderList) {
            toDeinit.addAll(holder.getTraits());
        }
        for (Trait trait : toDeinit) {
            trait.deInit();
        }
        this.traitHolderList.clear();
    }

    protected abstract void initDefaultHolder();

    protected void readTraitHolderList() {
        this.readTraitHolderListStep1();
        this.readTraitHolderListStep2();
        this.readTraitHolderListStep3();
    }

    protected void readTraitHolderListStep1() {
        this.traitHolderList.clear();
        Set<File> files = FileUtils.getAllFiles(this.folder);
        if (files.isEmpty()) {
            return;
        }
        for (File file : files) {
            YAMLConfigExtended config = new YAMLConfigExtended(file).load();
            if (!config.getValidLoad()) {
                this.plugin.log("Could not load " + this.getConfigPrefix() + " file: " + file.getName() + " because the Synthax is broken.");
                continue;
            }
            for (String holderName : config.getRootChildren()) {
                AbstractTraitHolder container = this.generateTraitHolder(config, holderName);
                if (container == null) continue;
                this.traitHolderList.add(container);
            }
        }
    }

    protected void readTraitHolderListStep2() {
        for (AbstractTraitHolder holder : this.traitHolderList) {
            try {
                holder.load();
            }
            catch (HolderParsingException exp) {
                String errorMessage = "Error: ";
                if (exp instanceof HolderConfigParseException) {
                    errorMessage = String.valueOf(errorMessage) + "ConfigTotal of: " + holder.getConfigNodeName() + " is mal formated. Please relook synthax!";
                } else if (exp instanceof HolderTraitParseException) {
                    HolderTraitParseException rtpe = (HolderTraitParseException)exp;
                    errorMessage = rtpe.getLocalizedMessage();
                }
                this.plugin.log(errorMessage);
            }
        }
    }

    protected void readTraitHolderListStep3() {
        for (AbstractTraitHolder holder : this.traitHolderList) {
            holder.readParents();
        }
    }

    protected abstract AbstractTraitHolder generateTraitHolder(YAMLConfigExtended var1, String var2);

    protected abstract String getCorrectFieldFromDBHolder(PlayerHolderAssociation var1);

    public boolean addPlayerToHolder(RaCPlayer player, String potentialHolder, boolean callAfterEvent) {
        AbstractTraitHolder container = this.getHolderByName(potentialHolder);
        if (container == null) {
            return false;
        }
        this.memberList.put(player, container);
        String groupName = container.getPermissions().getGroupIdentificationName();
        PermissionRegisterer.addPlayer(player, groupName);
        this.resetPlayerMovementSpeed(player);
        this.saveToContainer(player.getPlayerSaveData(), container);
        if (callAfterEvent) {
            HolderSelectedEvent event = this.generateAfterSelectEvent(player, container);
            this.plugin.fireEventToBukkit(event);
        }
        this.plugin.getPlayerManager().getContainer(player).rescan();
        return true;
    }

    protected abstract void saveToContainer(PlayerSavingData var1, AbstractTraitHolder var2);

    protected abstract HolderSelectedEvent generateAfterSelectEvent(RaCPlayer var1, AbstractTraitHolder var2);

    protected abstract HolderSelectedEvent generateAfterChangeEvent(RaCPlayer var1, AbstractTraitHolder var2, AbstractTraitHolder var3);

    protected abstract void saveContainerToDBField(PlayerHolderAssociation var1, String var2);

    private void resetPlayerMovementSpeed(RaCPlayer player) {
        if (player != null && player.isOnline()) {
            player.getPlayer().setWalkSpeed(0.2f);
        }
    }

    public AbstractTraitHolder getHolderByName(String holderName) {
        if (holderName == null) {
            return this.getDefaultHolder();
        }
        for (AbstractTraitHolder holder : this.traitHolderList) {
            if (!holder.getDisplayName().equalsIgnoreCase(holderName) && !holder.getConfigNodeName().equals(holderName)) continue;
            return holder;
        }
        return null;
    }

    protected abstract String getConfigPrefix();

    public boolean changePlayerHolder(RaCPlayer player, String newHolderName, boolean callEvent) {
        if (this.getHolderByName(newHolderName) == null) {
            return false;
        }
        AbstractTraitHolder oldHolder = this.getHolderOfPlayer(player);
        PermissionRegisterer.removePlayer(player, this.getContainerTypeAsString());
        this.memberList.remove(player);
        boolean worked = this.addPlayerToHolder(player, newHolderName, false);
        if (callEvent) {
            AbstractTraitHolder newHolder = this.getHolderOfPlayer(player);
            HolderSelectedEvent event = this.generateAfterChangeEvent(player, newHolder, oldHolder);
            this.plugin.fireEventToBukkit(event);
        }
        return worked;
    }

    public AbstractTraitHolder getHolderOfPlayer(RaCPlayer player) {
        if (player == null) {
            return null;
        }
        AbstractTraitHolder holder = this.memberList.get(player);
        if (holder == null) {
            PlayerSavingData data = PlayerSavingManager.get().getPlayerData(player.getUniqueId());
            holder = this.getHolder(data);
            if (holder == null) {
                holder = this.getDefaultHolder();
            }
            this.memberList.put(player, holder);
        }
        return holder;
    }

    protected abstract AbstractTraitHolder getHolder(PlayerSavingData var1);

    protected abstract AbstractTraitHolder getStartingHolder();

    public abstract AbstractTraitHolder getDefaultHolder();

    public List<String> getAllHolderNames() {
        LinkedList<String> holderNameList = new LinkedList<String>();
        for (AbstractTraitHolder holder : this.traitHolderList) {
            holderNameList.add(holder.getDisplayName());
        }
        return holderNameList;
    }

    public List<RaCPlayer> getAllPlayersOfHolder(AbstractTraitHolder holder) {
        if (holder == null) {
            return new LinkedList<RaCPlayer>();
        }
        LinkedList<RaCPlayer> holderMemberList = new LinkedList<RaCPlayer>();
        for (RaCPlayer playerUUID : this.memberList.keySet()) {
            AbstractTraitHolder toCheckAgainst = this.memberList.get(playerUUID);
            if (!holder.equals(toCheckAgainst)) continue;
            holderMemberList.add(playerUUID);
        }
        return holderMemberList;
    }

    public List<String> listAllVisibleHolders() {
        ArrayList<String> holderList = new ArrayList<String>();
        for (AbstractTraitHolder container : this.traitHolderList) {
            if (container.equals(this.getDefaultHolder())) continue;
            holderList.add(container.getDisplayName());
        }
        return holderList;
    }

    private void setupPermissions() {
        if (!this.isVaultUsed()) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new PermissionRegisterer(this.traitHolderList, this.memberList, this.getContainerTypeAsString()), 1L);
    }

    private boolean isVaultUsed() {
        return this.plugin.getPermissionManager().getPermissionsName().equalsIgnoreCase("Vault");
    }

    public abstract String getContainerTypeAsString();
}

