/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.datacontainer.arrow;

import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.TraitHolderCombinder;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.resolvers.WorldResolver;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.arrows.AbstractArrow;
import de.tobiyas.racesandclasses.traitcontainer.traits.statictraits.NormalArrow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ArrowManager {
    private ArrayList<AbstractArrow> arrows;
    private int currentPointer;
    private RaCPlayer player;
    private long eventTime;

    public ArrowManager(RaCPlayer player) {
        this.player = player;
        this.arrows = new ArrayList();
        this.currentPointer = 0;
        this.eventTime = 0L;
    }

    public void rescanPlayer() {
        this.arrows.clear();
        Set<Trait> traits = TraitHolderCombinder.getSkillTreeReducedTraitsOfPlayer(this.player);
        for (Trait arrow : traits) {
            if (!(arrow instanceof AbstractArrow) || arrow.isBindable()) continue;
            this.arrows.add((AbstractArrow)arrow);
        }
        Collections.sort(this.arrows);
        if (this.arrows.size() < this.currentPointer) {
            this.currentPointer = 0;
        }
    }

    public AbstractArrow nextArrow() {
        if (System.currentTimeMillis() - this.eventTime < 100L) {
            return null;
        }
        if (this.arrows.size() <= 0) {
            return null;
        }
        if (WorldResolver.isOnDisabledWorld(this.player)) {
            return null;
        }
        ++this.currentPointer;
        if (this.currentPointer >= this.arrows.size()) {
            this.currentPointer = 0;
        }
        AbstractArrow arrow = this.arrows.get(this.currentPointer);
        this.eventTime = System.currentTimeMillis();
        return arrow;
    }

    public AbstractArrow previousArrow() {
        if (System.currentTimeMillis() - this.eventTime < 100L) {
            return null;
        }
        if (WorldResolver.isOnDisabledWorld(this.player)) {
            return null;
        }
        if (this.arrows.size() <= 0) {
            return null;
        }
        --this.currentPointer;
        if (this.currentPointer < 0) {
            this.currentPointer = this.arrows.size() - 1;
        }
        AbstractArrow arrow = this.arrows.get(this.currentPointer);
        this.eventTime = System.currentTimeMillis();
        return arrow;
    }

    public AbstractArrow getCurrentArrow() {
        if (WorldResolver.isOnDisabledWorld(this.player)) {
            return null;
        }
        if (this.arrows.size() <= 0) {
            this.rescanPlayer();
        }
        if (this.arrows.size() <= 0) {
            return null;
        }
        AbstractArrow arrow = this.arrows.get(this.currentPointer);
        return arrow;
    }

    public int getNumberOfArrowTypes() {
        return WorldResolver.isOnDisabledWorld(this.player) ? 0 : this.arrows.size() - 1;
    }

    public boolean hasAnyArrow() {
        int size = this.arrows.size();
        switch (size) {
            case 0: {
                return false;
            }
            case 1: {
                return !(this.arrows.get(0) instanceof NormalArrow);
            }
        }
        return true;
    }

    public List<AbstractArrow> getAllArrows() {
        if (WorldResolver.isOnDisabledWorld(this.player)) {
            return new ArrayList<AbstractArrow>();
        }
        return new ArrayList<AbstractArrow>(this.arrows);
    }
}

