/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.datacontainer.armorandtool;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.datacontainer.armorandtool.AbstractItemPermission;
import de.tobiyas.racesandclasses.datacontainer.armorandtool.AllItemsPermission;
import de.tobiyas.racesandclasses.datacontainer.armorandtool.ItemPermission;
import de.tobiyas.racesandclasses.datacontainer.armorandtool.MaterialArmorPermission;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.classes.ClassContainer;
import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.race.RaceContainer;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.resolvers.WorldResolver;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.util.items.ItemUtils;
import java.util.HashSet;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;

public class ArmorToolManager {
    private HashSet<AbstractItemPermission> itemPerms;
    private RaCPlayer player;

    public ArmorToolManager(RaCPlayer player) {
        this.player = player;
        this.itemPerms = new HashSet();
    }

    public void rescanPermission() {
        ClassContainer classContainer;
        this.itemPerms.clear();
        if (this.player != null && !this.player.isOnline() && WorldResolver.isOnDisabledWorld(this.player)) {
            this.itemPerms.add(new AllItemsPermission());
            return;
        }
        RaceContainer container = this.player.getRace();
        if (container != null) {
            for (ItemUtils.ItemQuality quality : container.getArmorPerms()) {
                this.addPerm(quality);
            }
        }
        if ((classContainer = this.player.getclass()) != null) {
            for (ItemUtils.ItemQuality quality : classContainer.getArmorPerms()) {
                this.addPerm(quality);
            }
        }
        this.addDefaultPerm();
    }

    private void addDefaultPerm() {
        this.itemPerms.add(new ItemPermission(Material.SKULL_ITEM));
        this.itemPerms.add(new ItemPermission(Material.PUMPKIN));
    }

    private void addPerm(ItemUtils.ItemQuality quality) {
        for (AbstractItemPermission perm : this.itemPerms) {
            if (!perm.isAlreadyRegistered(quality)) continue;
            return;
        }
        this.itemPerms.add(new MaterialArmorPermission(quality));
    }

    public boolean hasPermissionForItem(ItemStack stack) {
        if (stack == null || stack.getType() == Material.AIR) {
            return true;
        }
        for (AbstractItemPermission permission : this.itemPerms) {
            if (!permission.hasPermission(stack)) continue;
            return true;
        }
        return false;
    }

    public double calcDamageToArmor(double damage, EntityDamageEvent.DamageCause cause) {
        if (this.player == null) {
            return damage;
        }
        switch (cause) {
            case FALL: 
            case FIRE: 
            case FIRE_TICK: 
            case LAVA: 
            case DROWNING: 
            case LIGHTNING: 
            case SUICIDE: 
            case STARVATION: 
            case POISON: {
                return damage;
            }
        }
        double playerArmor = this.getArmorLevel(this.player.getPlayer());
        double playerDamageReduce = 1.0 - 8.0 * playerArmor / 200.0;
        return damage * playerDamageReduce;
    }

    public int getArmorLevel(Player player) {
        return 0;
    }

    public boolean checkArmorNotValidEquiped() {
        if (this.player == null) {
            return true;
        }
        boolean disableArmorCheck = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().isConfig_disableArmorChecking();
        if (disableArmorCheck) {
            return true;
        }
        ItemStack helmet = ItemUtils.getItemInArmorSlotOfPlayer(this.player.getPlayer(), ItemUtils.ArmorSlot.HELMET);
        ItemStack chest = ItemUtils.getItemInArmorSlotOfPlayer(this.player.getPlayer(), ItemUtils.ArmorSlot.CHESTPLATE);
        ItemStack legs = ItemUtils.getItemInArmorSlotOfPlayer(this.player.getPlayer(), ItemUtils.ArmorSlot.LEGGINGS);
        ItemStack boots = ItemUtils.getItemInArmorSlotOfPlayer(this.player.getPlayer(), ItemUtils.ArmorSlot.BOOTS);
        boolean everythingOK = true;
        if (!this.hasPermissionForItem(helmet)) {
            if (!this.player.getPlayer().getInventory().addItem(new ItemStack[]{helmet}).isEmpty()) {
                this.player.getPlayer().getWorld().dropItem(this.player.getLocation(), helmet);
            }
            this.player.getPlayer().getInventory().setHelmet(new ItemStack(Material.AIR));
            everythingOK = false;
        }
        if (!this.hasPermissionForItem(chest)) {
            if (!this.player.getPlayer().getInventory().addItem(new ItemStack[]{chest}).isEmpty()) {
                this.player.getPlayer().getWorld().dropItem(this.player.getLocation(), chest);
            }
            this.player.getPlayer().getInventory().setChestplate(new ItemStack(Material.AIR));
            everythingOK = false;
        }
        if (!this.hasPermissionForItem(legs)) {
            if (!this.player.getPlayer().getInventory().addItem(new ItemStack[]{legs}).isEmpty()) {
                this.player.getPlayer().getWorld().dropItem(this.player.getLocation(), legs);
            }
            this.player.getPlayer().getInventory().setLeggings(new ItemStack(Material.AIR));
            everythingOK = false;
        }
        if (!this.hasPermissionForItem(boots)) {
            if (!this.player.getPlayer().getInventory().addItem(new ItemStack[]{boots}).isEmpty()) {
                this.player.getPlayer().getWorld().dropItem(this.player.getLocation(), boots);
            }
            this.player.getPlayer().getInventory().setBoots(new ItemStack(Material.AIR));
            everythingOK = false;
        }
        return everythingOK;
    }
}

